/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.pswing;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.io.Serializable;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.extras.pswing.PSwingEvent;
import org.piccolo2d.extras.pswing.PSwingMouseMotionEvent;
import org.piccolo2d.extras.pswing.PSwingMouseWheelEvent;
import org.piccolo2d.util.PPickPath;

public class PSwingMouseEvent
extends MouseEvent
implements Serializable,
PSwingEvent {
    private static final long serialVersionUID = 1L;
    private final int id;
    private final transient PInputEvent event;

    protected PSwingMouseEvent(int id, MouseEvent swingEvent, PInputEvent piccoloEvent) {
        super((Component)swingEvent.getSource(), swingEvent.getID(), swingEvent.getWhen(), swingEvent.getModifiers(), swingEvent.getX(), swingEvent.getY(), swingEvent.getClickCount(), swingEvent.isPopupTrigger());
        this.id = id;
        this.event = piccoloEvent;
    }

    public static PSwingEvent createMouseEvent(int id, MouseEvent swingEvent, PInputEvent pEvent) {
        if (pEvent == null) {
            throw new IllegalArgumentException("PInputEvent associated with PSwingEvent may not be null");
        }
        if (id == 503 || id == 506) {
            return new PSwingMouseMotionEvent(id, swingEvent, pEvent);
        }
        if (id == 507) {
            return new PSwingMouseWheelEvent(id, (MouseWheelEvent)swingEvent, pEvent);
        }
        return new PSwingMouseEvent(id, swingEvent, pEvent);
    }

    public Point2D getLocalPoint() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public double getLocalX() {
        return this.getLocalPoint().getX();
    }

    public double getLocalY() {
        return this.getLocalPoint().getY();
    }

    public int getID() {
        return this.id;
    }

    public PNode getNode() {
        return this.event.getPickedNode();
    }

    public PPickPath getPath() {
        return this.event.getPath();
    }

    public PNode getGrabNode() {
        return this.event.getPickedNode();
    }

    public PPickPath getGrabPath() {
        return this.getPath();
    }

    public PNode getCurrentNode() {
        return this.event.getPickedNode();
    }

    public PPickPath getCurrentPath() {
        return this.getPath();
    }

    public void dispatchTo(Object listener) {
        MouseListener mouseListener = (MouseListener)listener;
        switch (this.getID()) {
            case 500: {
                mouseListener.mouseClicked(this);
                break;
            }
            case 504: {
                mouseListener.mouseEntered(this);
                break;
            }
            case 505: {
                mouseListener.mouseExited(this);
                break;
            }
            case 501: {
                mouseListener.mousePressed(this);
                break;
            }
            case 502: {
                mouseListener.mouseReleased(this);
                break;
            }
            default: {
                throw new RuntimeException("PMouseEvent with bad ID");
            }
        }
    }

    public void setSource(Object newSource) {
        this.source = newSource;
    }

    public MouseEvent asMouseEvent() {
        return this;
    }
}

