/*   Theorur - A GUI for Ogg/Theora streaming
 *   Copyright (C) 2006-2009 Rafael Diniz <rafael@riseup.net>
 *
 *   This file is part of Theorur.
 *
 *   Theorur is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Theorur is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Theorur.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <libintl.h>

#ifndef __GTK_H__
#include <gtk/gtk.h>
#endif


#ifndef __GLOBAL_H__
#include "global.h"
#endif

#ifndef __CONSTANTS_H__
#include "constants.h"
#endif

#ifndef __CONFIG_FILES_H__
#include "config_files.h"
#endif

/* function inspired from darkice */
char *file_add_date(char *filename) {
  unsigned int size;
  char *s;
  char *strdate;
  char *last;
  time_t now;


  strdate = (char *) calloc(128, sizeof(char));
  now     = time(NULL);
  strftime(strdate, 128, "-%Y.%m.%d-%H:%M.%S", localtime (&now));
  
  /* search for the part before the extension of the file name */
  if ( !(last = strrchr( filename, '.')) ) {
    last = (char *) filename + strlen(filename);
  }
  
  size = strlen(filename) + strlen(strdate) + 1;
  s = (char *) calloc(size, sizeof(char));
  
  memcpy(s, filename, strlen(filename) - strlen(last));
  memcpy(s + strlen(filename) -  strlen(last), strdate, strlen(strdate));
  memcpy(s + strlen(filename) -  strlen(last) + strlen(strdate),
	  last,
	  strlen(last));
  s[size-1] = '\0';
  
  free(strdate);

  return s;
  
}

gboolean theorur_config_store(char opt, char *save_path) {
  int i;
  char mp[128];
  char *server;
  char *port;
  char *mountpoint;
  char *pass;
  char *localdump_enc;
  char *localdump_raw;
  char *streamname;
  char *description;
  char *url;
  char *genre;
  char *aquality;
  char *vquality;
  char *input;
  char *achannel;
  char *asamplerate;
  char *vfps;
  char *vsize;
  char *v4ldevice;
  char *adevice;
  char *public;
  char adddate;
  char reconnect;


  FILE *f_theorur_cfg;
  
  /* Entry inputs */
  server = (char *) gtk_entry_get_text ( (GtkEntry *) entry_server);
  port = (char *) gtk_entry_get_text (( GtkEntry *) entry_port);
  mountpoint = (char *) gtk_entry_get_text ( (GtkEntry *) entry_mountpoint);
  pass = (char *) gtk_entry_get_text ( (GtkEntry *) entry_pass);
  localdump_enc = (char *) gtk_entry_get_text ( (GtkEntry *) entry_localdump_enc);
  localdump_raw = (char *) gtk_entry_get_text ( (GtkEntry *) entry_localdump_raw);
  streamname = (char *) gtk_entry_get_text ( (GtkEntry *) entry_streamname);
  description = (char *) gtk_entry_get_text ( (GtkEntry *) entry_description);
  url = (char *) gtk_entry_get_text ( (GtkEntry *) entry_url);
  genre = (char *) gtk_entry_get_text ( (GtkEntry *) entry_genre);

  adddate = (char) (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (checkbutton_adddate) ))? '1': '0';
  reconnect = (char) (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (checkbutton_reconnect) ))? '1': '0';
    
  /* Combo box inputs */
  input = (char *) gtk_entry_get_text ( GTK_ENTRY( GTK_COMBO(combo_input)->entry));
  achannel = (char *) gtk_entry_get_text ( GTK_ENTRY(GTK_COMBO (combo_achannel)->entry ));
  asamplerate = (char *) gtk_entry_get_text ( GTK_ENTRY(GTK_COMBO(combo_asamplerate)->entry));
  vfps = (char *) gtk_entry_get_text ( GTK_ENTRY(GTK_COMBO(combo_vfps)->entry));
  vsize = (char *) gtk_entry_get_text ( GTK_ENTRY(GTK_COMBO(combo_vsize)->entry));
  v4ldevice = (char *) gtk_entry_get_text ( GTK_ENTRY(GTK_COMBO(combo_v4ldevice)->entry));
  adevice = (char *) gtk_entry_get_text ( GTK_ENTRY(GTK_COMBO(combo_adevice)->entry));
  public = (char *) gtk_entry_get_text  ( GTK_ENTRY(GTK_COMBO(combo_public)->entry));
  aquality = (char *) gtk_entry_get_text ( GTK_ENTRY(GTK_COMBO(combo_aquality)->entry) );
  vquality = (char *) gtk_entry_get_text ( GTK_ENTRY(GTK_COMBO(combo_vquality)->entry) );

  

  if (!( f_theorur_cfg = (opt != 0)? fopen(theorur_cfg, "w") : fopen(save_path, "w"))) {
      printf("Error: Cannot open %s\n", (opt != 0)? theorur_cfg: save_path);
      return FALSE;
  }

  /* If the mountpoint start with a slash, remove it. The slash will be put back for oggfwd  */
  i = 0;
  while( mountpoint[i] == ' ' || mountpoint[i] == '/' ) i++;
  strcpy (mp, mountpoint+i);
  

  /* Entry writes */
  fprintf (f_theorur_cfg, "server=%s\n", server);
  fprintf (f_theorur_cfg, "port=%s\n", port);
  fprintf (f_theorur_cfg, "mountpoint=%s\n", mp);
  fprintf (f_theorur_cfg, "pass=%s\n", pass);
  fprintf (f_theorur_cfg, "localdump_enc=%s\n", localdump_enc);
  fprintf (f_theorur_cfg, "localdump_raw=%s\n", localdump_raw);
  fprintf (f_theorur_cfg, "streamname=%s\n", streamname);
  fprintf (f_theorur_cfg, "description=%s\n", description);
  fprintf (f_theorur_cfg, "url=%s\n", url);
  fprintf (f_theorur_cfg, "genre=%s\n", genre);
  fprintf (f_theorur_cfg, "aquality=%s\n", aquality);
  fprintf (f_theorur_cfg, "vquality=%s\n", vquality);
  fprintf (f_theorur_cfg, "input=%s\n", input);
  fprintf (f_theorur_cfg, "achannel=%s\n", achannel);
  fprintf (f_theorur_cfg, "asamplerate=%s\n", asamplerate);
  fprintf (f_theorur_cfg, "vfps=%s\n", vfps);
  fprintf (f_theorur_cfg, "vsize=%s\n", vsize);
  fprintf (f_theorur_cfg, "v4ldevice=%s\n", v4ldevice);
  fprintf (f_theorur_cfg, "adevice=%s\n", adevice);
  fprintf (f_theorur_cfg, "public=%s\n", public);
  fprintf (f_theorur_cfg, "adddate=%c\n", adddate);
  fprintf (f_theorur_cfg, "reconnect=%c\n", reconnect);;

  
  fclose (f_theorur_cfg);
  
  return TRUE;
}

gboolean theorur2theoracmd_cfg() {
  FILE *f_theorur_cfg;
  int i, x, y;
  char *retval;

  /* strings section */
  char foo[256] = {0};
  char server[256] = {0};
  char port[128] = {0};
  char mountpoint[128] = {0};
  char pass[128] = {0};
  char localdump_enc[256] = {0};
  char localdump_raw[256] = {0};
  char streamname[128] = {0};
  char description[256] = {0};
  char url[256] = {0};
  char genre[128] = {0};
  char aquality[128] = {0};
  char vquality[128] = {0};
  char input[128] = {0};
  char achannel[128] = {0};
  char asamplerate[128] = {0};
  char vfps[128] = {0};
  char vsize[128] = {0};
  char v4ldevice[128] = {0};
  char adevice[128] = {0};
  char public[128] = {0};
  char adddate;
  char reconnect;

  if (!(f_theorur_cfg = fopen(theorur_cfg, "r"))) {
    printf("Error: Cannot open %s\n", theorur_cfg);
    exit (-1);
  }
  
  /* read de configuration from theorur config file */
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, server);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, port);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, mountpoint);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, pass);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, localdump_enc);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, localdump_raw);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, streamname);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, description);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, url);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, genre);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, aquality);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, vquality);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, input);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, achannel);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, asamplerate);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, vfps);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, vsize);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, v4ldevice);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, adevice);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, public);
  fscanf(f_theorur_cfg, "%[^=]=%c\n", foo, &adddate);
  fscanf(f_theorur_cfg, "%[^=]=%c\n", foo, &reconnect);

  

  if (reconnect == '1') 
    reconnect_flag = 1;

  if (!strcmp(input, gettext("IEEE1394 - digital input"))) { /* dv */
    sprintf(theorur_cmd, "dvgrab --format raw - | ");
    
    for (x = 0; localdump_raw[x] != 0 && localdump_raw[x] == ' '; x++); /* set the localdump_raw file name */
    if (localdump_raw[x] != 0) {
      if (adddate == '1') {
	i = strlen(theorur_cmd);
	sprintf(theorur_cmd+i, "tee %s | ", retval = file_add_date(localdump_raw+x));
	free(retval);
      }
      else {
	i = strlen(theorur_cmd);
	sprintf(theorur_cmd+i, "tee %s | ", localdump_raw+x);  
      }
    }  
   

    i = strlen(theorur_cmd);    
    sprintf(theorur_cmd+i, "ffmpeg2theora -f dv -H %s -a %s -v %s ", asamplerate, aquality, vquality);

    if (strcmp (vsize, gettext("don't change"))){
      sscanf(vsize,"%dx%d", &x, &y);
      i = strlen(theorur_cmd);    
      sprintf(theorur_cmd+i, "-x %d -y %d ", x, y);
    }

    if (strcmp(vfps, gettext("don't change"))){
      i = strlen(theorur_cmd);
      sprintf(theorur_cmd+i, "-F %s -K %d ", vfps, atoi(vfps) * 4); // keyframes = vfs * 4
    }
    else {
      sprintf(theorur_cmd+i, "-K 110 "); 
    }
    
    if (!strcmp(achannel, "1 - Mono"))
      strcat(theorur_cmd, "-c 1 ");
    else /* 2 - Stereo */
      strcat(theorur_cmd, "-c 2 ");

    i = strlen(theorur_cmd);
    sprintf(theorur_cmd+i, " -o /dev/stdout - | ");

    for (x = 0; localdump_enc[x] != 0 && localdump_enc[x] == ' '; x++); /* set the localdump_encfile name */
    if (localdump_enc[x] != 0) {
      if (adddate == '1') {
	i = strlen(theorur_cmd);
	sprintf(theorur_cmd+i, "tee %s | ", retval = file_add_date(localdump_enc+x));
	free(retval);
      }
      else {
	i = strlen(theorur_cmd);
	sprintf(theorur_cmd+i, "tee %s | ", localdump_enc+x);  
      }
    }  
        
    i = strlen(theorur_cmd);
    sprintf(theorur_cmd+i, "oggfwd %s -d \"%s\" -g \"%s\" -n \"%s\" -u \"%s\" %s %s %s /%s ", (strcmp(public, gettext("yes")))? " ":"-p", description, genre, streamname, url, server, port, pass, mountpoint);
    
  }
  else { /* v4l */
    sprintf(theorur_cmd, "ffmpeg -f video4linux2 -i %s -f oss -i %s -ac %d - | ffmpeg2theora -H %s -a %s -v %s ", v4ldevice, adevice, 
	    (!strcmp(achannel, "1 - Mono"))? 1:2 , asamplerate, aquality, vquality);

    if (strcmp (vsize, gettext("don't change"))){
      i = strlen(theorur_cmd);    
      sscanf(vsize,"%dx%d", &x, &y);
      sprintf(theorur_cmd+i, "-x %d -y %d ", x, y);
    }

    if (strcmp(vfps, gettext("don't change"))){
      i = strlen(theorur_cmd);
      sprintf(theorur_cmd+i, "-F %s -K %d ", vfps, atoi(vfps)*4); // keyframes == vfps * 4
    }
 
    if (!strcmp(achannel, "1 - Mono"))
      strcat(theorur_cmd, "-c 1 ");
    else /* 2 - Stereo */
      strcat(theorur_cmd, "-c 2 ");

    i = strlen(theorur_cmd);
    sprintf(theorur_cmd+i, " -o /dev/stdout - | ");

    for (x = 0; localdump_enc[x] != 0 && localdump_enc[x] == ' '; x++); /* set the localdump_enc file name */
    if (localdump_enc[x] != 0) {
      if (adddate == '1') {
	i = strlen(theorur_cmd);
	sprintf(theorur_cmd+i, "tee %s | ", retval = file_add_date(localdump_enc+x));
	free(retval);
      }
      else {
	i = strlen(theorur_cmd);
	sprintf(theorur_cmd+i, "tee %s | ", localdump_enc+x);  
      }
    }  

    i = strlen(theorur_cmd);
    sprintf(theorur_cmd+i, "oggfwd %s -d \"%s\" -g \"%s\" -n \"%s\" -u \"%s\" %s %s %s /%s ", (strcmp(public, gettext("yes")))? " ":"-p", description, genre, streamname, url, server, port, pass, mountpoint);
   

    /* code for v4l with audio -- still experimental, if you want to try it, change 0 to 1 */
#if 0 
    sprintf(theorur_cmd, "ffmpeg -s %s ", vsize);

    if (!strcmp(achannel, "1 - Mono"))
      strcat(theorur_cmd, "-ac 1 ");
    else /* 2 - Stereo */
      strcat(theorur_cmd, "-ac 2 ");
    
    /* if (strcmp(vfps, gettext("don't change"))){
      i = strlen(theorur_cmd);
      sprintf(theorur_cmd+i, "-r %s ", vfps);
    }*/
    
    i = strlen(theorur_cmd);
    sprintf(theorur_cmd+i, "-f video4linux -i %s -f audio_device -i /dev/dsp -itsoffset -3.0 -ar %s -map 0.0 -map 1.0 -f mpeg -y - 2> /dev/null | ffmpeg2theora -a %s -v %s -o /dev/stdout - | ", v4ldevice, asamplerate, aquality, vquality, theorur_temp);
   
    for (x = 0; localdump_enc[x] != 0 && localdump_enc[x] == ' '; x++); /* set the localdump_enc file name */
    if (localdump_enc[x] != 0) {
      if (adddate == '1') {
	i = strlen(theorur_cmd);
	sprintf(theorur_cmd+i, "tee %s | ", retval = file_add_date(localdump_enc+x));
	free(retval);
      }
      else {
	i = strlen(theorur_cmd);
	sprintf(theorur_cmd+i, "tee %s | ", localdump_enc+x);  
      }
    }
    
    
    i = strlen(theorur_cmd);
    sprintf(theorur_cmd+i, "oggfwd %s -d \"%s\" -g \"%s\" -n \"%s\" -u \"%s\" %s %s %s /%s ", (strcmp(public, gettext("yes")))? " ":"-p", description, genre, streamname, url, server, port, pass, mountpoint);

#endif

  }

  
  fclose(f_theorur_cfg);


  return TRUE;
}
