/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef BGFILEPARSE_H
#define BGFILEPARSE_H


#include <QString>
#include <QMap>

class QXmlStreamReader;

typedef struct _BgInfo{

    QString status;
    QString name;
    QString i18nName;
    QString artist;
    QString filename;
    QString option;
    QString pColor;
    QString sColor;
    QString shadeType;

}BgInfo;

class BgFileParse
{

public:
    explicit BgFileParse();
    ~BgFileParse();


public:

    static QMap<QString, BgInfo> bgFileReader();
    static void parseWallpaper(QXmlStreamReader &reader);


//private:
//    static QMap<QString, BgInfo> wholeBgInfo;

};

#endif // BGFILEPARSE_H
