/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */   
#include <vdkb2/vdkb_locale.h>
#include <vdkb2/vdkb.h>
#include <vdkb2/vdkb_utils.h>

extern bool CheckDebugger(char* exe);
/*
this state machine manages
enabling/disabling menu/speedbar
functions
 */
static char buff[256];
void
VDKBMainForm::Automa(int state)
{
VDKString pname;
char* q;
int t;
bool have_make;
while (state != automa_end)
  {
    switch(state)
      {
      case automa_error:
	state = automa_end;
	break;
      case automa_init:
	// disable most of menu functions
	save_item->Enabled = false;
	saveall_item->Enabled = false;
	//edit_menu->Enabled = false;
	search_menu->Enabled = false;
	view_menu->Enabled = false;
	viewunits_item->Enabled = false;
	viewforms_item->Enabled = false;
	prj_menu->Enabled = false;
	newform_item->Enabled = true;
	tools_menu->Enabled = true;
	compo_menu->Enabled = true;
	// disable some speedbar buttons
	/*
	(*toolbar)[NEW_FORM_BUTTON]->Enabled = false; 
	(*toolbar)[SAVE_PRJ_BUTTON]->Enabled = false;
	(*toolbar)[SAVE_FILE_BUTTON]->Enabled = false;
	*/
	nb_array[NEW_FORM_BUTTON]->Enabled = false; 
	nb_array[SAVE_PRJ_BUTTON]->Enabled = false;
	nb_array[SAVE_FILE_BUTTON]->Enabled = false;

	for(t=0; t < 4; t++)
	  // (*toolbar1)[t]->Enabled = false;
	  nb_array1[t]->Enabled = false;
	// enables help on vdk ref
	help_vdk->Enabled = 
        strcmp((char*) VDKBuilder::ideDefaults.project.vdk_ref_path,"?") != 0;
	state = automa_end;
	break;

      case automa_editor_on:
	// will be activated when gui cut&paste will be enabled.
	save_item->Enabled = true;
	saveall_item->Enabled = true;
	search_menu->Enabled = true;
	//(*toolbar)[SAVE_FILE_BUTTON]->Enabled = true;
	nb_array[SAVE_FILE_BUTTON]->Enabled = true;
	state = automa_end;
	break;

      case automa_editor_off:
	save_item->Enabled = false;
	saveall_item->Enabled = false;
	search_menu->Enabled = false;
	viewunits_item->Enabled = false;
	// disable some speedbar buttons
	// (*toolbar)[SAVE_PRJ_BUTTON]->Enabled = false;
	// (*toolbar)[SAVE_FILE_BUTTON]->Enabled = false;
	nb_array[SAVE_PRJ_BUTTON]->Enabled = false;
	nb_array[SAVE_FILE_BUTTON]->Enabled = false;
	state = automa_end;
	break;

      case automa_prjman_on:
	prj_menu->Enabled = true;
	//	(*toolbar)[SAVE_PRJ_BUTTON]->Enabled = true;
	// (*toolbar)[NEW_FORM_BUTTON]->Enabled = true;
	nb_array[SAVE_PRJ_BUTTON]->Enabled = true;
	nb_array[NEW_FORM_BUTTON]->Enabled = true;
	exec_item->Enabled = true;
	view_menu->Enabled = true;
	viewforms_item->Enabled = true;
	ac_menu->Enabled = true;
	//	(*toolbar1)[FORM_LIST]->Enabled = true;
	nb_array1[FORM_LIST]->Enabled = true;
	// enable others ac support
	sprintf(buff,"%s/Makefile",(char*) prjman->Project()->Path);
	have_make = !access(buff,F_OK);
	ac_make->Enabled = have_make;
	ac_makeclean->Enabled = have_make;
	ac_makedist->Enabled = have_make;
	ac_makedistclean->Enabled = have_make;
	// checks if executable exists
	pname = prjman->Project()->PathName;
	q = get_extension( (char*) pname);
	// another weird bug
	// for an obscure reason .prj could be gone away
	// april 6 ,99
	// not so obscure now: 
	// just a bad data hiding concept on using VDKString::(char*)
	// conversion operator, but it's late to correct it
	if(!q)
	  {
	    pname += ".prj";
	    q = get_extension( (char*) pname);
	    *q = '\0';
	  }
	else
	  *q = '\0';
	{
	  bool executable = true;
	  //	  (*toolbar1)[RUN_PRJ_BUTTON]->Enabled = executable;
	  nb_array1[RUN_PRJ_BUTTON]->Enabled = executable;
	  // check if debugger option is empty or not
	  bool isdebug = 
	      CheckDebugger((char*) prjman->Project()->Options()->debugger);
	  //  bool isdebug = !(prjman->Project()->Options()->debugger.isNull());
	  prjdebug_item->Enabled = executable && isdebug;
	}
	state = automa_end;
	break;
   
      case automa_prjman_off:
	prj_menu->Enabled = false;
	//	(*toolbar)[SAVE_PRJ_BUTTON]->Enabled = false;
	//	(*toolbar)[NEW_FORM_BUTTON]->Enabled = false;
	nb_array[SAVE_PRJ_BUTTON]->Enabled = false;
	nb_array[NEW_FORM_BUTTON]->Enabled = false;
	prjdebug_item->Enabled = false;
	ac_menu->Enabled = false;
	state = automa_end;
	break;

      case automa_edit_form_on:
	// enable boxes
	(*containers_widgets_bar)[0]->Enabled = true;
	(*containers_widgets_bar)[1]->Enabled = true;
	// reset->Enabled = true;
	state = automa_end;
	break;

      case automa_edit_form_off:
	// disable boxes
	(*containers_widgets_bar)[0]->Enabled = false;
	(*containers_widgets_bar)[1]->Enabled = false;
	// reset->Enabled = false;
	state = automa_end;
	break;

      default:
	state = automa_end;
	break;
      }
  }
}


