# Copyright 2019 Xilinx Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may not
# use this file except in compliance with the License. You may obtain a copy of
# the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations under
# the License.

include("${CMAKE_CURRENT_LIST_DIR}/unilog-targets.cmake")
set(unilog_FOUND True)

get_target_property(TARGET_LOCATION unilog::unilog LOCATION)
message(
  STATUS
    "Found importable target unilog::unilog: ${TARGET_LOCATION}"
)

get_filename_component(unilog_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}"
                       PATH)
set(unilog_INCLUDE_DIRS "${unilog_CMAKE_DIR}/../../../include")

find_package(glog QUIET)
if(NOT glog_FOUND)
  message(STATUS "cannot find glogConfig.cmake fallback to pkg-config")
  find_package(PkgConfig)
  pkg_search_module(PKG_GLOG REQUIRED IMPORTED_TARGET GLOBAL libglog)
  add_library(glog::glog ALIAS PkgConfig::PKG_GLOG)
endif(NOT glog_FOUND)
include("${CMAKE_CURRENT_LIST_DIR}/vai_add_pybind11_module.cmake")
