#pragma once

#include <date/tz.h>
#include "ALabel.hpp"
#include "util/sleeper_thread.hpp"

namespace waybar {

struct waybar_time;

namespace modules {

const std::string kCalendarPlaceholder = "calendar";

class Clock : public ALabel {
 public:
  Clock(const std::string&, const Json::Value&);
  ~Clock() = default;
  auto update() -> void;

 private:
  util::SleeperThread thread_;
  std::locale locale_;
  std::vector<const date::time_zone*> time_zones_;
  int current_time_zone_idx_;
  date::year_month_day cached_calendar_ymd_ = date::January/1/0;
  std::string cached_calendar_text_;
  bool is_calendar_in_tooltip_;

  bool handleScroll(GdkEventScroll* e);

  auto calendar_text(const waybar_time& wtime) -> std::string;
  auto weekdays_header(const date::weekday& first_dow, std::ostream& os) -> void;
  auto first_day_of_week() -> date::weekday;
  const date::time_zone* current_timezone();
  bool is_timezone_fixed();
};

}  // namespace modules
}  // namespace waybar
