target=delchar delhead deltail delmid nospace singlespace trim derepeat deltype delparity delwref delmark1 delmark2

#include "header.inc"
#include "confparm.inc"
#define TRANS 1
\text{sizelim1=5}
\text{sizelim2=1999}

\text{remove=randitem(removes, deletes, erases, suppresses)}

#if #TARGET (delchar)
 \title{Cut: Designated character}
 \text{chars=\allchars}
 \text{c=wims(charcnt \alpha)}
 \text{c=wims(char randint(1..\c) of \alpha)}
 \text{result=\remove all appearances of the characters <tt>'\c'<tt> from the string.}
#endif

#if #TARGET (delhead)
 \title{Cut: Head of the string}
 \integer{cut=randint(2..20)}
 \text{result=\remove up to \cut characters from the beginning of the string.}
#endif

#if #TARGET (deltail)
 \title{Cut: End of the string}
 \integer{cut=randint(2..20)}
 \text{result=\remove up to \cut characters from the end of the string.}
#endif

#if #TARGET (delmid)
 \title{Cut: Middle of the string}
 \integer{start=randint(3..20)}
 \integer{cut=randint(2..20)}
 \text{result=\remove up to \cut characters starting from character number
	\start of the string.}
#endif

#if #TARGET (nospace)
 \title{Cut: Spacing characters}
 \text{result=\remove all spacing characters (space, tab, new ligne) of the string.}
#endif

#if #TARGET (singlspace)
 \title{Cut: Simplify spaces}
 \text{result=replaces all successive sequences of spacing characters (space, tab, new ligne)
 of the string by a single space (<tt>' '</tt>).}
#endif

#if #TARGET (trim)
 \title{Cut: Trim}
 \text{result=\remove sequences of spacing characters (space, tab, new ligne)
 at the beginning and the end of the string.}
#endif

#if #TARGET (derepeat)
 \title{Cut: Repetitions}
 \text{result=\remove all characters of the string which are identical to its
	preceeding character.}
#endif

#if #TARGET (deltype)
 \title{Cut: Type of characters}
 \text{chars=\allchars}
 \text{data=randomrow(
	alphabetic characters,1,\alpha
	non-alphabetic characters,0,\alpha
	lower-case alphabetic characters,1,\lower
	characters other than lower-case alphabetic ones,0,\lower
	upper-case alphabetic characters,1,\upper
	characters other than upper-case alphabetic ones,0,\upper
	numerical digits (0,1,...,9),1,\digits
	characters other than numerical digits (0,1,...,9),0,\digits
	mathematic operators (<tt>+-*/^=</tt>),1,\mathop
)}
 \text{result=\remove all the \data[1] of the string.}
#endif

#if #TARGET (delparity)
 \title{Cut: Parity of position}
 \if{randitem(0,1) = 0}{
  \text{mask=10}
  \text{result=\remove all characters of even position in the string
	(second, fourth, sixth, ...).}
 }{
  \text{mask=01}
  \text{result=\remove all characters of odd position in the string
	(first, third, fifth, ...).}
 }
#endif

#if #TARGET (delwref)
 \title{Cut: Word of rfrence}
 \text{word=wims(exec randic randint(8..14))}
 \text{word=wims(deaccent \word)}
 \text{wordl=wims(tolower \word)}
 \text{wordu=wims(toupper \word)}
 \integer{dir=random(0,1)}
 \text{data=randrow(
   both cases,\wordl\wordu
   lower-case only,\wordl
   upper-case only,\wordu
)}
 \text{result=\remove all characters in the string that are part
	of the word <tt>\word</tt> (\data[1]).}
#endif

#if #TARGET (delmark1)
 \title{Cut: Marker I}
 \integer{markcnt=1}
 #define MARK 1
#endif
#if #TARGET (delmark2)
 \title{Cut: Marker II}
 \integer{markcnt=randitem(2,3,-1)}
 #define MARK 1
#endif

#ifdef MARK
 #include "mark.inc"
 \text{result=\remove \data[1] of the string.}
#endif

\text{compare=}
\text{listsc=}
\integer{shift=randint(0..10)}
\text{ns=wims(values x for x in 0,1,2,3,4,5,
	  8,10,10+\shift,21+\shift,33+\shift,
	  42+\shift,51+\shift,72+\shift,83+\shift,100+\shift,
	  randint(150..200),randint(200..300),randint(500..800),
	  randint(\sizelim2-100..\sizelim2-1)
)}
\for{n in \ns}{
 #include "list.inc"
 \text{listsc=wims(append item "\list" to \listsc)}
#if #TARGET (delchar)
 \text{list1=wims(text remove \c in \list)}
#endif
#if #TARGET (delhead)
 \text{list1=wims(char \cut+1 to -1 of \list)}
#endif
#if #TARGET (deltail)
 \text{list1=wims(char 1 to -\cut-1 of \list)}
#endif
#if #TARGET (delmid)
 \text{head=wims(char 1 to \start-1 of \list)}
 \text{tail=wims(char \start+\cut to -1 of \list)}
 \text{list1=\head\tail}
#endif
#if #TARGET (nospace)
 \text{list1=wims(translate internal  to \spc\spc in \list)}
 \text{list1=wims(nospace \list1)}
#endif
#if #TARGET (singlspace)
 \text{list1=wims(translate internal  to \spc\spc in \list)}
 \text{list1=wims(singlspace \list1)}
#endif
#if #TARGET (trim)
 \text{list1=\list}
 \text{c=wims(char 1 of \list1)}
 \integer{l=wims(charcnt \list1)}
  % Do not use "\list1 notsametext \null"! Bug in case when \list1 has only spaces.
 \while{\l > 0 and \c isin \space} {
  \text{list1=wims(char 2 to -1 of \list1)}
  \text{c=wims(char 1 of \list1)}
  \integer{l=wims(charcnt \list1)}
 }
 \text{c=wims(char -1 of \list1)}
 \while{\l > 0 and \c isin \space} {
  \text{list1=wims(char 1 to -2 of \list1)}
  \text{c=wims(char -1 of \list1)}
  \integer{l=wims(charcnt \list1)}
 }
#endif
#if #TARGET (derepeat)
 \text{l1=wims(char 1 to -2 of \list)}
 \text{l2=wims(char 2 to -1 of \list)}
 \text{mask=wims(text compare \l1 and \l2)}
 \text{list1=wims(text copy \list mask 1\mask)}
#endif
#if #TARGET (deltype)
 \if{\data[2] = 1}{
  \text{list1=wims(text remove \data[3] in \list)}
 }{
  \text{list1=wims(text select \data[3] in \list)}
 }
#endif
#if #TARGET (delparity)
 \text{list1=wims(text copy \list mask \mask)}
#endif
#if #TARGET (delwref)
 \text{list1=wims(text remove \data[2] in \list)}
#endif
#ifdef MARK
 \text{mask=wims(text mark \data[2] in \list)}
 \text{appear=item(\markcnt,wims(positionof char 1 in \mask))}
 \if{\appear notsametext }{
  \text{list1=wims(char 1 to \appear-1 of \list)wims(char \appear+1 to -1 of \list)}
 }{
  \text{list1=\list}
 }
#endif
 \text{compare=\compare(\list1),}
}

#include "src.inc"
#include "example.inc"
#include "main.inc"

