target=rochas1 rochas2 rochas3 rochasdiag3 rochasdiag1 rochasdiag2
#define GRADV 0.05
#define GRADT 1000
#define GRADP 10
#define CYCLE Beau de Rochas

\text{PV=\(P = f(V)) ,\(P = f(T)), \(V = f(T))}
\computeanswer{yes}
\author{Bernadette Perrin-Riou et Jean-Ren Vacher}
\email{bpr@math.u-psud.fr}

#if #TARGET(rochas1)
\title{CYCLE. Calcul des variables}
\text{enonce=Complter le tableau suivant en entrant vos rponses dans 
les cases.}

\integer{choixdiagr=\confparm1 iswordof 1 2 3 ? \confparm1 : randint(1..3)}
\text{PV=\PV[\choixdiagr]}
\integer{size=300}
#endif
#if #TARGET(rochas2)
\title{CYCLE. Calcul d'nergie}
\integer{choixdiagr=\confparm1 iswordof 1 2 3 ? \confparm1 : randint(1..3)}
\text{PV=\PV[\choixdiagr]}
\integer{size=300}
#endif

#if #TARGET(rochas3)
\title{CYCLE. Rendement}
\integer{choixdiagr=\confparm1 iswordof 1 2 3 ? \confparm1 : randint(1..3)}
\text{PV=\PV[\choixdiagr]}
\integer{size=300}
#endif


#if #TARGET(rochasdiag3)
\title{CYCLE. Diagramme (3)}
\integer{choixdiagr=\confparm1 iswordof 1 2 3 ? \confparm1 : randint(1..3)}
\text{PV=\PV[\choix]}
\integer{size=300}
#endif



#if #TARGET(rochasdiag1)
\title{CYCLE. Diagramme (1)}
\text{bat=shuffle(3)}
\integer{choixdiagr=\bat[1]}
text{PV=(V,P), (T,P),(T,V)}
\text{PV=\PV[\bat]}
\text{choix=randint(1..3)}
text{d=\PV[\choix]}
\integer{size=200}
#endif

#if #TARGET(rochasdiag2)
\title{CYCLE. Diagramme (2)} 
\integer{choixdiagr=\confparm1 iswordof 1 2 3 ? \confparm1 : randint(1..3)}
\integer{size=300}
#endif

\precision{100}
\real{VB=randint(20..40)*0.001}
\real{TC=randint(2000..2500)}
\real{TA=300}
\real{PA=1}
\real{VA=0.1}

#include "formulerochas.inc"
#if #TARGET(rochas1) || #TARGET(rochasdiag3) || #TARGET(rochasdiag1) || #TARGET(rochasdiag2)
#include "dessin.inc"
#endif

#if #TARGET(rochas1) || #TARGET(rochasdiag3)
\text{Dessin2=draw(\size,\size
\dessin)}
#endif


#if #TARGET(rochasdiag3)
\text{Dessin=draw(\size,\size
\dessinprelim
\echelle
\grandeur)}
#endif

#if #TARGET(rochasdiag1)
\text{dessin=\dessinprelim
\echelle
\grandeur
\diagramme
\points
\texteABCD
}
\text{Dessin=<img src=draw(\size,\size
\dessinprelim
\diagramme)>}
\integer{choixdiagr=\bat[2]}
#include "dessin.inc"
\text{Dessin=\Dessin,<img src=draw(\size,\size
\dessinprelim
\diagramme)>}
\integer{choixdiagr=\bat[3]}
#include "dessin.inc"
\text{Dessin=\Dessin,<img src=draw(\size,\size
\dessinprelim
\diagramme)>}
#endif

#if #TARGET(rochasdiag2)
\text{Dessin=draw(\size,\size
\dessinprelim
\diagramme)}
#endif

#if #TARGET(rochas1) || #TARGET(rochas2) || #TARGET(rochasdiag3) || #TARGET(rochas3)
\text{ABCD=A,B,C,D}
\matrix{Rep = \PA,\VA,\TA
\PB,\VB,\TB
\PC,\VC,\TC
\PD,\VD,\TD
}
\text{approx = pari((f(r,n)= 
  l=if(r != 0, floor(log(abs(r))/log(10)),1) ; 
s =round(10^(-l+n)*r) ; [l,s]))}

\integer{app=3}

\text{PB_approx=pari(f(\PB,\app))}
\real{PB_app=\PB_approx[2]*10^(-\app+\PB_approx[1])}
\text{TB_approx=pari(f(\TB,\app))}
\real{TB_app=\TB_approx[2]*10^(-\app+\TB_approx[1])}
\text{PC_approx=pari(f(\PC,\app))}
\real{PC_app=\PC_approx[2]*10^(-\app+\PC_approx[1])}
\text{VC_approx=pari(f(\VC,\app))}
\real{VC_app=\VC_approx[2]*10^(-\app+\VC_approx[1])}
\text{PD_approx=pari(f(\PD,\app))}
\real{PD_app=\PD_approx[2]*10^(-\app+\PD_approx[1])}
\text{VD_approx=pari(f(\VD,\app))}
\real{VD_app=\VD_approx[2]*10^(-\app+\VD_approx[1])}
\text{TD_approx=pari(f(\TD,\app))}
\real{TD_app=\TD_approx[2]*10^(-\app+\TD_approx[1])}

\matrix{Repc =\PA,\VA,\TA
\PB_app,\VB,\TB_app
\PC_app,\VC_app,\TC
\PD_app,\VD_app,\TD_app}

\matrix{REP = wims(replace internal ; by , in \Rep)}
\matrix{REPc = wims(replace internal ; by , in \Repc)}

\real{tolerance=1}
\text{REP4=pari(\REP[4]*[(1-\tolerance/100),(1+\tolerance/100)]),\REPc[4]}
\text{REP6=pari(\REP[6]*[(1-\tolerance/100),(1+\tolerance/100)]),\REPc[6]}
\text{REP7=pari(\REP[7]*[(1-\tolerance/100),(1+\tolerance/100)]),\REPc[7]}
\text{REP8=pari(\REP[8]*[(1-\tolerance/100),(1+\tolerance/100)]),\REPc[8]}
\text{REP10=pari(\REP[10]*[(1-\tolerance/100),(1+\tolerance/100)]),\REPc[10]}
\text{REP11=pari(\REP[11]*[(1-\tolerance/100),(1+\tolerance/100)]),\REPc[11]}
\text{REP12=pari(\REP[12]*[(1-\tolerance/100),(1+\tolerance/100)]),\REPc[12]}

\text{ABCD2= \(A \rightarrow B), \(B \rightarrow C), \(C \rightarrow D),
\(D \rightarrow A), Cycle}

\matrix{Rep2=\QAB,\WAB,\DUAB,\DHAB
\QBC,\WBC,\DUBC,\DHBC
\QCD,\WCD,\DUCD,\DHCD
\QDA,\WDA,\DUDA,\DHDA
\Q,\W,0,0}
 
\text{Repapp=}
\for{h = 1 to 5}{
  \for{k=1 to 4}{
    \text{r=\Rep2[\h;\k]}
    \text{r_approx=pari(f(\r,\app))}
    \real{r_app=\r_approx[2]*10^(-\app+\r_approx[1])}
    \if{\k==1}{\text{Repapp=\Repapp \r_app}}{
      \text{Repapp=\Repapp,\r_app}}
   }
   \text{Repapp=\Repapp;}
}
\text{Repmin=pari([\Rep2]*(1-\tolerance/100))}
\text{Repmax=pari([\Rep2]*(1+\tolerance/100))}


#endif
\text{enoncegeneral=<i>Ce cycle thorique correspond au fonctionnement d'un moteur    explosion  
quatre temps dans lequel la combustion du carburant est remplace par
l'chauffement d'un gaz dont la composition reste constante au cours du
cycle.
</i>

<p>Un gaz parfait diatomique est admis  la pression de \PA bar dans le cylindre d'un moteur de 
volume \(V_A) de \VA L  la temprature de \TA K. Il subit les transformations 
rversibles suivantes : 
<ul>
<li> \(A \rightarrow B) : compression adiabatique jusqu'au volume \(V_B = \VB L \) 
de la chambre de combustion ; 
</li><li>
\(B \rightarrow C) : chauffement  volume constant jusqu' atteindre une 
temprature \(T_C = \TC K) ; 
</li><li>\(C \rightarrow D) : dtente adiabatique jusqu'au volume initial ; 
</li><li>\(D \rightarrow A) : refroidissement du gaz  volume constant
jusqu' la pression initiale.
</li></ul>
}

#if #TARGET(rochas2) || #TARGET(rochasdiag3) || #TARGET(rochas3)

\text{tableau_reponse=<table align="center" border = 1>
  <tr align="center" bgcolor=skyblue>
   <th>Etape</th>
   <th>\(P) (bar)</th>
   <th>\(V)  (L)</th>
   <th>\(T) (K)</th>
  </tr>}
  
  \for{i=1 to 4}{
 \text{tableau_reponse= \tableau_reponse
 <tr>
   <th>\(\ABCD[\i])</th>}
   
   \for{j=1 to 3}{ \text{tableau_reponse= \tableau_reponse<td align="center">
       \Repc[\i;\j] </td>}
      }
   \text{tableau_reponse= \tableau_reponse</tr>}
  }
\text{tableau_reponse= \tableau_reponse </table>}

#endif

#if #TARGET(rochas2) || #TARGET(rochas3)
\text{tableau_reponse2=<table align="center" border = 1>
  <tr align="center" bgcolor=skyblue>
   <th>&nbsp;</th>
   <th> Q (J)</th>
   <th> W  (J)</th>
   <th>\(\Delta) U (J)</th>
   <th>\(\Delta) H (J)</th>
  </tr>}
  
  \for{i=1 to 5}{
 \text{tableau_reponse2= \tableau_reponse2
 <tr>
   <th>\ABCD2[\i]</th>}
   \for{j=1 to 4}{ \text{tableau_reponse2= \tableau_reponse2<td align="center">
       \Repapp[\i;\j] </td>}
      }
   \text{tableau_reponse2= \tableau_reponse2</tr>}
  }
\text{tableau_reponse2= \tableau_reponse2 </table>}
#endif


#if #TARGET(rochasdiag3) || #TARGET(rochasdiag2)
\if{\choixdiagr=1}{
\text{coord=slib(draw/convpixel \VA,\PA,\size,\size,\xrange,\yrange,0,pixels)}
\text{coord=\coord,slib(draw/convpixel \VB,\PB,\size,\size,\xrange,\yrange,0,pixels)}
\text{coord=\coord,slib(draw/convpixel \VC,\PC,\size,\size,\xrange,\yrange,0,pixels)}
\text{coord=\coord,slib(draw/convpixel \VD,\PD,\size,\size,\xrange,\yrange,0,pixels)}
}

\if{\choixdiagr=2}{
\text{coord=slib(draw/convpixel \TA,\PA,\size,\size,\xrange,\yrange,0,pixels)}
\text{coord=\coord,slib(draw/convpixel \TB,\PB,\size,\size,\xrange,\yrange,0,pixels)}
\text{coord=\coord,slib(draw/convpixel \TC,\PC,\size,\size,\xrange,\yrange,0,pixels)}
\text{coord=\coord,slib(draw/convpixel \TD,\PD,\size,\size,\xrange,\yrange,0,pixels)}
}

\if{\choixdiagr=3}{
\text{coord=slib(draw/convpixel \TA,\VA,\size,\size,\xrange,\yrange,0,pixels)}
\text{coord=\coord,slib(draw/convpixel \TB,\VB,\size,\size,\xrange,\yrange,0,pixels)}
\text{coord=\coord,slib(draw/convpixel \TC,\VC,\size,\size,\xrange,\yrange,0,pixels)}
\text{coord=\coord,slib(draw/convpixel \TD,\VD,\size,\size,\xrange,\yrange,0,pixels)}
}

#endif

#if #TARGET(rochasdiag3)

\statement{
\enoncegeneral
<table width=100%><tr><td align="center" valign=top>On obtient le tableau suivant : 
\tableau_reponse
</td><td align="center" valign=top>

Placer les points sur le diagramme : 
\embed{reply1}
</td></tr></table>}

\answer{}{\Dessin;points,\coord}{type=javacurve}
\feedback{1= 1}{ Voici le cycle : 
<p  align="center">
<img src= "\Dessin2">
</p>
}
#endif


#if #TARGET(rochas1)
\text{Commentaire = \(P_A),\(V_A),\(T_A),
\(P_B),\(V_B),\(T_B),
\(P_C),\(V_C),\(T_C),
\(P_D),\(V_D),\(T_D)
}
\matrix{STEP=,,
r1,,r2
r3,r4,
r5,r6,r7
}
\text{nstep = wims(replace internal ; by , in \STEP)}
\text{nstep = wims(nonempty items \nstep)}

\steps{\nstep}



\statement{
\enoncegeneral

\enonce
<table align="center" border = 1>
  <tr align="center" bgcolor=skyblue>
   <th>Etape</th>
   <th>\(P) (bar)</th>
   <th>\(V)  (L)</th>
   <th>\(T) (K)</th>
  </tr>
  \for{n=1 to 4}{
  <tr>
   <th>\ABCD[\n]</th>
   \for{m=1 to 3}{ <td align="center">
      \if{\STEP[\n;\m] notsametext }{ \embed{\STEP[\n;\m],12}}
        { \Rep[\n;\m]} </td>
      }
  </tr>
  }
</table>
}

\answer{\Commentaire[4]}{\REP4}{type=range}
\answer{\Commentaire[6]}{\REP6}{type=range}
\answer{\Commentaire[7]}{\REP7}{type=range}
\answer{\Commentaire[8]}{\REP8}{type=range}
\answer{\Commentaire[10]}{\REP10}{type=range}
\answer{\Commentaire[11]}{\REP11}{type=range}
\answer{\Commentaire[12]}{\REP12}{type=range}


\matrix{Reponse=\PA,\VA,\TA
\reply1,\VB,\reply2
\reply3,\reply4,\TC
\reply5,\reply6,\reply7}

Il faudrait calculer la plus grande valeur pour  les  volumes et pressions. Je prends
ici un xrange  la louche

\real{cinqpix=(\xrange[2]-(\xrange[1]))/300*5}
\real{cinqpiy=(\yrange[2]-(\yrange[1]))/300*5}
\text{numero=\choixdiagr=1 ? 2,1}
\text{numero=\choixdiagr=2 ? 3,1}
\text{numero=\choixdiagr=3 ? 3,2}
\text{dessin_feed=\dessin
line \Reponse[1;\numero[1]] - \cinqpix,\Reponse[1;\numero[2]]-\cinqpiy,\Reponse[1;\numero[1]] + \cinqpix,\Reponse[1;\numero[2]] + \cinqpiy,black
line \Reponse[1;\numero[1]] + \cinqpix,\Reponse[1;\numero[2]]-\cinqpiy,\Reponse[1;\numero[1]] - \cinqpix,\Reponse[1;\numero[2]] + \cinqpiy,black
line \Reponse[2;\numero[1]] - \cinqpix,\Reponse[2;\numero[2]]-\cinqpiy,\Reponse[2;\numero[1]] + \cinqpix,\Reponse[2;\numero[2]] + \cinqpiy,black
line \Reponse[2;\numero[1]] + \cinqpix,\Reponse[2;\numero[2]]-\cinqpiy,\Reponse[2;\numero[1]] - \cinqpix,\Reponse[2;\numero[2]] + \cinqpiy,black
line \Reponse[3;\numero[1]] - \cinqpix,\Reponse[3;\numero[2]]-\cinqpiy,\Reponse[3;\numero[1]] + \cinqpix,\Reponse[3;\numero[2]] + \cinqpiy,black
line \Reponse[3;\numero[1]] + \cinqpix,\Reponse[3;\numero[2]]-\cinqpiy,\Reponse[3;\numero[1]] - \cinqpix,\Reponse[3;\numero[2]] + \cinqpiy,black
line \Reponse[4;\numero[1]] - \cinqpix,\Reponse[4;\numero[2]]-\cinqpiy,\Reponse[4;\numero[1]] + \cinqpix,\Reponse[4;\numero[2]] + \cinqpiy,black
line \Reponse[4;\numero[1]] + \cinqpix,\Reponse[4;\numero[2]]-\cinqpiy,\Reponse[4;\numero[1]] - \cinqpix,\Reponse[4;\numero[2]] + \cinqpiy,black
}
\text{Dessin_feed=draw(\size,\size
\dessin_feed)
}
\feedback{1= 1}{Voici votre rponse dans le diagramme \PV : 
<p  align="center">
<img src= "\Dessin_feed">
</p>
}

#endif

#if #TARGET(rochas2)
\matrix{STEP=r1,r2,r3,r4
r5,r6,r7,r8
r9,r10,r11,r12
r13,r14,r15,r16
r17,r18,r19,r20
}
\text{STEP1=wims(lines2items wims(rows2lines \STEP))}
\steps{\STEP1}
\statement{
\enoncegeneral

Calculer la chaleur, le travail, la variation d'nergie et d'enthalpie du gaz 
pour chacune de ces transformations et sur le cycle complet. Entrer
vos rponses dans chaque case du tableau. 

<table width=100%><tr><td align="center" valign=top>On obtient le tableau suivant : 
\tableau_reponse
</td><td align="center" valign=top>
<table align="center" border = 1>
  <tr align="center" bgcolor=skyblue>
   <th>&nbsp;</th>
   <th> Q (J)</th>
   <th> W  (J)</th>
   <th>\(\Delta) U (J)</th>
   <th>\(\Delta) H (J)</th>
  </tr> 
  \for{u=1 to 5}{
   <tr> <th>\ABCD2[\u]</th> 
   \for{v=1 to 4}{ <td align="center">       
       \embed{\STEP[\u;\v],6}       
       </td>
       }
   </tr>
}
</table>
</td></tr></table>}

\answer{\(Q_{A\to B})}{\Repmin[1;1],\Repmax[1;1],\Repapp[1;1]}{type=range}
\answer{\(W_{A\to B})}{\Repmin[1;2],\Repmax[1;2],\Repapp[1;2]}{type=range}
\answer{\(\Delta U_{A\to B})}{\Repmin[1;3],\Repmax[1;3],\Repapp[1;3]}{type=range}
\answer{\(\Delta H_{A\to B})}{\Repmin[1;4],\Repmax[1;4],\Repapp[1;4]}{type=range}

\answer{\(Q_{B\to C})}{\Repmin[2;1],\Repmax[2;1],\Repapp[2;1]}{type=range}
\answer{\(W_{B\to C})}{\Repmin[2;2],\Repmax[2;2],\Repapp[2;2]}{type=range}
\answer{\(\Delta U_{B\to C})}{\Repmin[2;3],\Repmax[2;3],\Repapp[2;3]}{type=range}
\answer{\(\Delta H_{B\to C})}{\Repmin[2;4],\Repmax[2;4],\Repapp[2;4]}{type=range}

\answer{\(Q_{C\to D})}{\Repmin[3;1],\Repmax[3;1],\Repapp[3;1]}{type=range}
\answer{\(W_{C\to D})}{\Repmin[3;2],\Repmax[3;2],\Repapp[3;2]}{type=range}
\answer{\(\Delta U_{C\to D})}{\Repmin[3;3],\Repmax[3;3],\Repapp[3;3]}{type=range}
\answer{\(\Delta H_{C\to D})}{\Repmin[3;4],\Repmax[3;4],\Repapp[3;4]}{type=range}

\answer{\(Q_{D\to A})}{\Repmin[4;1],\Repmax[4;1],\Repapp[4;1]}{type=range}
\answer{\(W_{D\to A})}{\Repmin[4;2],\Repmax[4;2],\Repapp[4;2]}{type=range}
\answer{\(\Delta U_{D\to A})}{\Repmin[4;3],\Repmax[4;3],\Repapp[4;3]}{type=range}
\answer{\(\Delta H_{D\to A})}{\Repmin[4;4],\Repmax[4;4],\Repapp[4;4]}{type=range}

\answer{\(Q)}{\Repmin[5;1],\Repmax[5;1],\Repapp[5;1]}{type=range}
\answer{\(W)}{\Repmin[5;2],\Repmax[5;2],\Repapp[5;2]}{type=range}
\answer{\(\Delta U)}{\Repmin[5;3],\Repmax[5;3],\Repapp[5;3]}{type=range}
\answer{\(\Delta H)}{\Repmin[5;4],\Repmax[5;4],\Repapp[5;4]}{type=range}


#endif
#if #TARGET(rochas3)
\text{rendement= du rapport \(T_A/T_B),
des rapports \(V_C/V_B) et \(V_B/V_A),
du rapport \(V_A/V_B),
du rapport \(P_A/P_B)
}
\text{r_rend=3}
\text{ro_approx=pari(f(\ro,\app))}
\real{ro_app=\ro_approx[2]*10^(-\app+\ro_approx[1])}
\text{ro_rep=pari(\ro*[(1-\tolerance/100),(1+\tolerance/100)]),\ro_app}

\statement{\enoncegeneral
<p>
Voici les tableaux des variables et des nergies :
<table align="center"><tr><td>
\tableau_reponse </td><td>\tableau_reponse2</td></tr></table>

On dfinit le rendement \rho de ce moteur thermique comme 
le rapport du travail reu par le milieu extrieur par 
la chaleur reue par le gaz, sur un cycle.
<ul><li>
Ce rendement ne dpend que \embed{r1,250x40}
<i>(vous devez savoir le montrer)</i> ;
</li><li>
Calculer ce rendement : \embed{r2}
</li><li>
Vrifier le rsultat  l'aide des valeurs donnes par le tableau des nergies.
</li></ul>
}
\answer{}{\rendement[\r_rend];\rendement}{type=dragfill}
\answer{}{\ro_rep}{type=range}
#endif

#if #TARGET(rochasdiag1)
\statement{\enoncegeneral
<p> Quelle est la reprsentation du diagramme \PV[\choix]?

<p align="center">
\embed{reply1,1} &nbsp;\embed{reply1,2}&nbsp;\embed{reply1,3}
</p>
}
\answer{}{\choix;\Dessin}{type=radio}
#endif

#if #TARGET(rochasdiag2)
\matrix{pos=r 1,\coord[1] x\coord[2]
	r 2,\coord[3] x \coord[4]
	r 3,\coord[5] x\coord[6]
	r 4,\coord[7] x\coord[8]} 
\text{taille=20x20}
\statement{\enoncegeneral 
<p>Voici la reprsentation du diagramme 
\PV[\choixdiagr]. Placer les points \(A), \(B), \(C) et \(D)  : 

<p align="center">
\special{imagefill \Dessin,\size x \size, \taille
  \pos } </p>
  }

\answer{}{A}{type=dragfill}
\answer{}{B}{type=dragfill}
\answer{}{C}{type=dragfill}
\answer{}{D}{type=dragfill}
#endif

#include "hint.inc"
