/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.MeasurementPending;
import org.jmol.shape.FontLineShapeRenderer;
import org.jmol.shape.Measures;
import org.jmol.util.Point3fi;

public class MeasuresRenderer
extends FontLineShapeRenderer {
    private Measurement measurement;
    private boolean doJustify;
    private AxisAngle4f aaT = new AxisAngle4f();
    private Matrix3f matrixT = new Matrix3f();

    protected void render() {
        if (!this.g3d.checkTranslucent(false)) {
            return;
        }
        Measures measures = (Measures)this.shape;
        this.doJustify = this.viewer.getJustifyMeasurements();
        this.mad = measures.mad;
        this.imageFontScaling = this.viewer.getImageFontScaling();
        this.font3d = this.g3d.getFont3DScaled(measures.font3d, this.imageFontScaling);
        this.renderPendingMeasurement(measures.measurementPending);
        if (!this.viewer.getShowMeasurements()) {
            return;
        }
        this.clearBox();
        boolean bl = this.viewer.getShowMeasurementLabels();
        boolean bl2 = this.viewer.getDynamicMeasurements();
        measures.setVisibilityInfo();
        int n = measures.measurementCount;
        while (--n >= 0) {
            Measurement measurement = (Measurement)measures.measurements.get(n);
            if (bl2 || measurement.isDynamic()) {
                measurement.refresh();
            }
            if (!measurement.isVisible()) continue;
            this.colix = measurement.getColix();
            if (this.colix == 0) {
                this.colix = measures.colix;
            }
            if (this.colix == 0) {
                this.colix = this.viewer.getColixBackgroundContrast();
            }
            this.g3d.setColix(this.colix);
            this.renderMeasurement(measurement.getCount(), measurement, bl);
        }
    }

    private Point3fi getAtom(int n) {
        Point3fi point3fi = this.measurement.getAtom(n);
        if (point3fi.screenDiameter < 0) {
            this.viewer.transformPoint((Point3f)point3fi, this.pt0);
            point3fi.screenX = this.pt0.x;
            point3fi.screenY = this.pt0.y;
            point3fi.screenZ = this.pt0.z;
        }
        return point3fi;
    }

    private void renderMeasurement(int n, Measurement measurement, boolean bl) {
        this.measurement = measurement;
        switch (n) {
            case 2: {
                this.atomA = this.getAtom(1);
                this.atomB = this.getAtom(2);
                this.renderDistance(bl);
                break;
            }
            case 3: {
                this.atomA = this.getAtom(1);
                this.atomB = this.getAtom(2);
                this.atomC = this.getAtom(3);
                this.renderAngle(bl);
                break;
            }
            case 4: {
                this.atomA = this.getAtom(1);
                this.atomB = this.getAtom(2);
                this.atomC = this.getAtom(3);
                this.atomD = this.getAtom(4);
                this.renderTorsion(bl);
            }
        }
        this.atomD = null;
        this.atomC = null;
        this.atomB = null;
        this.atomA = null;
    }

    void renderDistance(boolean bl) {
        this.tickInfo = this.measurement.getTickInfo();
        if (this.tickInfo != null) {
            this.drawLine(this.atomA.screenX, this.atomA.screenY, this.atomA.screenZ, this.atomB.screenX, this.atomB.screenY, this.atomB.screenZ, this.mad);
            if (this.tickInfo != null) {
                this.drawTicks(this.atomA, this.atomB, this.mad);
            }
            return;
        }
        int n = this.atomA.screenZ - this.atomA.screenDiameter - 10;
        int n2 = this.atomB.screenZ - this.atomB.screenDiameter - 10;
        int n3 = this.drawLine(this.atomA.screenX, this.atomA.screenY, n, this.atomB.screenX, this.atomB.screenY, n2, this.mad);
        if (!bl) {
            return;
        }
        int n4 = (n + n2) / 2;
        if (n4 < 1) {
            n4 = 1;
        }
        int n5 = (this.atomA.screenX + this.atomB.screenX) / 2;
        int n6 = (this.atomA.screenY + this.atomB.screenY) / 2;
        this.drawString(n5, n6, n4, n3, this.doJustify && (n5 - this.atomA.screenX) * (n6 - this.atomA.screenY) > 0, false, false, this.doJustify ? 0 : Integer.MAX_VALUE, this.measurement.getString());
    }

    private void renderAngle(boolean bl) {
        int n = this.atomB.screenDiameter + 10;
        int n2 = this.atomA.screenZ - this.atomA.screenDiameter - 10;
        int n3 = this.atomB.screenZ - n;
        int n4 = this.atomC.screenZ - this.atomC.screenDiameter - 10;
        int n5 = this.drawLine(this.atomA.screenX, this.atomA.screenY, n2, this.atomB.screenX, this.atomB.screenY, n3, this.mad);
        n5 += this.drawLine(this.atomB.screenX, this.atomB.screenY, n3, this.atomC.screenX, this.atomC.screenY, n4, this.mad);
        if (!bl) {
            return;
        }
        n5 = (n5 + 1) / 2;
        AxisAngle4f axisAngle4f = this.measurement.getAxisAngle();
        if (axisAngle4f == null) {
            int n6 = (int)(5.0f * this.imageFontScaling);
            this.drawString(this.atomB.screenX + n6, this.atomB.screenY - n6, n3, n5, false, false, false, this.doJustify ? 0 : Integer.MAX_VALUE, this.measurement.getString());
            return;
        }
        int n7 = (int)((double)axisAngle4f.angle / (Math.PI * 2) * 64.0);
        float f = axisAngle4f.angle / (float)n7;
        this.aaT.set(axisAngle4f);
        int n8 = n7 / 2;
        Point3f point3f = this.measurement.getPointArc();
        int n9 = n7;
        while (--n9 >= 0) {
            this.aaT.angle = (float)n9 * f;
            this.matrixT.set(this.aaT);
            this.pointT.set(point3f);
            this.matrixT.transform(this.pointT);
            this.pointT.add(this.atomB);
            Point3i point3i = this.viewer.transformPoint(this.pointT);
            int n10 = point3i.z - n;
            if (n10 < 0) {
                n10 = 0;
            }
            this.g3d.drawPixel(point3i.x, point3i.y, n10);
            if (n9 != n8) continue;
            this.pointT.set(point3f);
            this.pointT.scale(1.1f);
            this.matrixT.transform(this.pointT);
            this.pointT.add(this.atomB);
            this.viewer.transformPoint(this.pointT);
            int n11 = point3i.z - n;
            this.drawString(point3i.x, point3i.y, n11, n5, point3i.x < this.atomB.screenX, false, false, this.doJustify ? this.atomB.screenY : Integer.MAX_VALUE, this.measurement.getString());
        }
    }

    private void renderTorsion(boolean bl) {
        int n = this.atomA.screenZ - this.atomA.screenDiameter - 10;
        int n2 = this.atomB.screenZ - this.atomB.screenDiameter - 10;
        int n3 = this.atomC.screenZ - this.atomC.screenDiameter - 10;
        int n4 = this.atomD.screenZ - this.atomD.screenDiameter - 10;
        int n5 = this.drawLine(this.atomA.screenX, this.atomA.screenY, n, this.atomB.screenX, this.atomB.screenY, n2, this.mad);
        n5 += this.drawLine(this.atomB.screenX, this.atomB.screenY, n2, this.atomC.screenX, this.atomC.screenY, n3, this.mad);
        n5 += this.drawLine(this.atomC.screenX, this.atomC.screenY, n3, this.atomD.screenX, this.atomD.screenY, n4, this.mad);
        if (!bl) {
            return;
        }
        this.drawString((this.atomA.screenX + this.atomB.screenX + this.atomC.screenX + this.atomD.screenX) / 4, (this.atomA.screenY + this.atomB.screenY + this.atomC.screenY + this.atomD.screenY) / 4, (n + n2 + n3 + n4) / 4, n5 /= 3, false, false, false, this.doJustify ? 0 : Integer.MAX_VALUE, this.measurement.getString());
    }

    private void renderPendingMeasurement(MeasurementPending measurementPending) {
        if (this.exportType != 0 || measurementPending == null) {
            return;
        }
        int n = measurementPending.getCount();
        if (n == 0) {
            return;
        }
        this.g3d.setColix(this.viewer.getColixRubberband());
        measurementPending.refresh();
        if (measurementPending.haveTarget()) {
            this.renderMeasurement(n, measurementPending, true);
        } else {
            this.renderPendingWithCursor(n, measurementPending);
        }
    }

    private void renderPendingWithCursor(int n, MeasurementPending measurementPending) {
        if (n > 1) {
            this.renderMeasurement(n, measurementPending, false);
        }
        this.measurement = measurementPending;
        Point3fi point3fi = this.getAtom(n);
        int n2 = point3fi.screenZ - point3fi.screenDiameter - 10;
        int n3 = this.viewer.getCursorX();
        int n4 = this.viewer.getCursorY();
        if (this.g3d.isAntialiased()) {
            n3 <<= 1;
            n4 <<= 1;
        }
        this.drawLine(point3fi.screenX, point3fi.screenY, n2, n3, n4, 0, this.mad);
    }

    protected int drawLine(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n7 >= 20 && this.exportType != 1 ? (int)this.viewer.scaleToScreen((n3 + n6) / 2, n7) : n7;
        return super.drawLine(n, n2, n3, n4, n5, n6, n8);
    }
}

