/* icon-button.c generated by valac 0.56.4, the Vala compiler
 * generated from icon-button.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include "libnotes.h"
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib-object.h>

#define M_PI 3.14159265358979323846

enum  {
	XNP_ICON_BUTTON_0_PROPERTY,
	XNP_ICON_BUTTON_NUM_PROPERTIES
};
static GParamSpec* xnp_icon_button_properties[XNP_ICON_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	XNP_ICON_BUTTON_CLICKED_SIGNAL,
	XNP_ICON_BUTTON_NUM_SIGNALS
};
static guint xnp_icon_button_signals[XNP_ICON_BUTTON_NUM_SIGNALS] = {0};
enum  {
	XNP_TITLE_BAR_BUTTON_0_PROPERTY,
	XNP_TITLE_BAR_BUTTON_ICON_TYPE_PROPERTY,
	XNP_TITLE_BAR_BUTTON_NUM_PROPERTIES
};
static GParamSpec* xnp_title_bar_button_properties[XNP_TITLE_BAR_BUTTON_NUM_PROPERTIES];

struct _XnpTitleBarButtonPrivate {
	XnpTitleBarButtonType _icon_type;
};

static gpointer xnp_icon_button_parent_class = NULL;
static gint XnpTitleBarButton_private_offset;
static gpointer xnp_title_bar_button_parent_class = NULL;

static void xnp_icon_button_real_draw_icon (XnpIconButton* self,
                                     cairo_t* cr,
                                     gint width,
                                     gint height);
static void xnp_icon_button_real_add (GtkContainer* base,
                               GtkWidget* widget);
static gboolean xnp_icon_button_real_draw (GtkWidget* base,
                                    cairo_t* cr);
static gboolean xnp_icon_button_on_enter_notify_event (XnpIconButton* self,
                                                GdkEventCrossing* event);
static gboolean xnp_icon_button_on_leave_notify_event (XnpIconButton* self,
                                                GdkEventCrossing* event);
static gboolean xnp_icon_button_on_button_release_event (XnpIconButton* self,
                                                  GdkEventButton* event);
static GObject * xnp_icon_button_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static gboolean _xnp_icon_button_on_enter_notify_event_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                               GdkEventCrossing* event,
                                                                               gpointer self);
static gboolean _xnp_icon_button_on_leave_notify_event_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                               GdkEventCrossing* event,
                                                                               gpointer self);
static gboolean _xnp_icon_button_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                   GdkEventButton* event,
                                                                                   gpointer self);
static void xnp_icon_button_finalize (GObject * obj);
static GType xnp_icon_button_get_type_once (void);
static void xnp_title_bar_button_real_draw_icon (XnpIconButton* base,
                                          cairo_t* cr,
                                          gint width,
                                          gint height);
static void xnp_title_bar_button_draw_close_button (XnpTitleBarButton* self,
                                             cairo_t* cr,
                                             gint width,
                                             gint height);
static void xnp_title_bar_button_draw_left_arrow_button (XnpTitleBarButton* self,
                                                  cairo_t* cr,
                                                  gint width,
                                                  gint height);
static void xnp_title_bar_button_draw_right_arrow_button (XnpTitleBarButton* self,
                                                   cairo_t* cr,
                                                   gint width,
                                                   gint height);
static void xnp_title_bar_button_draw_refresh_button (XnpTitleBarButton* self,
                                               cairo_t* cr,
                                               gint width,
                                               gint height);
static void xnp_title_bar_button_finalize (GObject * obj);
static GType xnp_title_bar_button_get_type_once (void);
static void _vala_xnp_title_bar_button_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_xnp_title_bar_button_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static void
xnp_icon_button_real_draw_icon (XnpIconButton* self,
                                cairo_t* cr,
                                gint width,
                                gint height)
{
	g_critical ("Type `%s' does not implement abstract method `xnp_icon_button_draw_icon'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
xnp_icon_button_draw_icon (XnpIconButton* self,
                           cairo_t* cr,
                           gint width,
                           gint height)
{
	XnpIconButtonClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = XNP_ICON_BUTTON_GET_CLASS (self);
	if (_klass_->draw_icon) {
		_klass_->draw_icon (self, cr, width, height);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
xnp_icon_button_set_widget_source_color (XnpIconButton* self,
                                         cairo_t* cr)
{
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_context = _tmp1_;
	_tmp3_ = gtk_widget_get_sensitive ((GtkWidget*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp2_ = self->active;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkStyleContext* _tmp5_;
		GdkRGBA _tmp6_ = {0};
		_tmp5_ = style_context;
		gtk_style_context_get_color (_tmp5_, GTK_STATE_FLAG_PRELIGHT, &_tmp6_);
		gdk_cairo_set_source_rgba (cr, &_tmp6_);
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = gtk_widget_get_sensitive ((GtkWidget*) self);
		_tmp9_ = _tmp8_;
		if (_tmp9_) {
			_tmp7_ = !self->active;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GtkStyleContext* _tmp10_;
			GdkRGBA _tmp11_ = {0};
			_tmp10_ = style_context;
			gtk_style_context_get_color (_tmp10_, GTK_STATE_FLAG_NORMAL, &_tmp11_);
			gdk_cairo_set_source_rgba (cr, &_tmp11_);
		} else {
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp12_ = gtk_widget_get_sensitive ((GtkWidget*) self);
			_tmp13_ = _tmp12_;
			if (!_tmp13_) {
				GtkStyleContext* _tmp14_;
				GdkRGBA _tmp15_ = {0};
				_tmp14_ = style_context;
				gtk_style_context_get_color (_tmp14_, GTK_STATE_FLAG_INSENSITIVE, &_tmp15_);
				gdk_cairo_set_source_rgba (cr, &_tmp15_);
			}
		}
	}
	_g_object_unref0 (style_context);
}

static void
xnp_icon_button_real_add (GtkContainer* base,
                          GtkWidget* widget)
{
	XnpIconButton * self;
	self = (XnpIconButton*) base;
	g_return_if_fail (widget != NULL);
	g_warning ("icon-button.vala:56: This object doesn't allow packing child widgets.");
}

static gboolean
xnp_icon_button_real_draw (GtkWidget* base,
                           cairo_t* cr)
{
	XnpIconButton * self;
	gint width = 0;
	gint height = 0;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gboolean result;
	self = (XnpIconButton*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_context = _tmp1_;
	gtk_style_context_save (style_context);
	gtk_style_context_add_class (style_context, GTK_STYLE_CLASS_BUTTON);
	gtk_render_frame (style_context, cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	gtk_render_background (style_context, cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	gtk_style_context_restore (style_context);
	cairo_save (cr);
	cairo_translate (cr, (gdouble) 2, (gdouble) 2);
	xnp_icon_button_draw_icon (self, cr, width - 4, height - 4);
	cairo_restore (cr);
	result = FALSE;
	_g_object_unref0 (style_context);
	return result;
}

static gboolean
xnp_icon_button_on_enter_notify_event (XnpIconButton* self,
                                       GdkEventCrossing* event)
{
	GdkWindow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->active = TRUE;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_invalidate_rect (_tmp0_, NULL, FALSE);
	result = FALSE;
	return result;
}

static gboolean
xnp_icon_button_on_leave_notify_event (XnpIconButton* self,
                                       GdkEventCrossing* event)
{
	GdkWindow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->active = FALSE;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_invalidate_rect (_tmp0_, NULL, FALSE);
	result = FALSE;
	return result;
}

static gboolean
xnp_icon_button_on_button_release_event (XnpIconButton* self,
                                         GdkEventButton* event)
{
	gint cur_x = 0;
	gint cur_y = 0;
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	cur_x = (gint) event->x;
	cur_y = (gint) event->y;
	gtk_widget_get_size_request ((GtkWidget*) self, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	if (cur_x >= 0) {
		_tmp4_ = cur_x < width;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = cur_y >= 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = cur_y < height;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		g_signal_emit (self, xnp_icon_button_signals[XNP_ICON_BUTTON_CLICKED_SIGNAL], 0);
	}
	result = FALSE;
	return result;
}

XnpIconButton*
xnp_icon_button_construct (GType object_type)
{
	XnpIconButton * self = NULL;
	self = (XnpIconButton*) g_object_new (object_type, NULL);
	return self;
}

static gboolean
_xnp_icon_button_on_enter_notify_event_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                      GdkEventCrossing* event,
                                                                      gpointer self)
{
	gboolean result;
	result = xnp_icon_button_on_enter_notify_event ((XnpIconButton*) self, event);
	return result;
}

static gboolean
_xnp_icon_button_on_leave_notify_event_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                      GdkEventCrossing* event,
                                                                      gpointer self)
{
	gboolean result;
	result = xnp_icon_button_on_leave_notify_event ((XnpIconButton*) self, event);
	return result;
}

static gboolean
_xnp_icon_button_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                          GdkEventButton* event,
                                                                          gpointer self)
{
	gboolean result;
	result = xnp_icon_button_on_button_release_event ((XnpIconButton*) self, event);
	return result;
}

static GObject *
xnp_icon_button_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XnpIconButton * self;
	parent_class = G_OBJECT_CLASS (xnp_icon_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_ICON_BUTTON, XnpIconButton);
	gtk_widget_set_name (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "notes-icon-button");
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	gtk_event_box_set_above_child ((GtkEventBox*) self, TRUE);
	gtk_widget_set_size_request ((GtkWidget*) self, 22, 22);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) _xnp_icon_button_on_enter_notify_event_gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _xnp_icon_button_on_leave_notify_event_gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _xnp_icon_button_on_button_release_event_gtk_widget_button_release_event, self, 0);
	return obj;
}

static void
xnp_icon_button_class_init (XnpIconButtonClass * klass,
                            gpointer klass_data)
{
	xnp_icon_button_parent_class = g_type_class_peek_parent (klass);
	((XnpIconButtonClass *) klass)->draw_icon = (void (*) (XnpIconButton*, cairo_t*, gint, gint)) xnp_icon_button_real_draw_icon;
	((GtkContainerClass *) klass)->add = (void (*) (GtkContainer*, GtkWidget*)) xnp_icon_button_real_add;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) xnp_icon_button_real_draw;
	G_OBJECT_CLASS (klass)->constructor = xnp_icon_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_icon_button_finalize;
	xnp_icon_button_signals[XNP_ICON_BUTTON_CLICKED_SIGNAL] = g_signal_new ("clicked", XNP_TYPE_ICON_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
xnp_icon_button_instance_init (XnpIconButton * self,
                               gpointer klass)
{
	self->active = FALSE;
}

static void
xnp_icon_button_finalize (GObject * obj)
{
	XnpIconButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_ICON_BUTTON, XnpIconButton);
	G_OBJECT_CLASS (xnp_icon_button_parent_class)->finalize (obj);
}

static GType
xnp_icon_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XnpIconButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_icon_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpIconButton), 0, (GInstanceInitFunc) xnp_icon_button_instance_init, NULL };
	GType xnp_icon_button_type_id;
	xnp_icon_button_type_id = g_type_register_static (gtk_event_box_get_type (), "XnpIconButton", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return xnp_icon_button_type_id;
}

GType
xnp_icon_button_get_type (void)
{
	static volatile gsize xnp_icon_button_type_id__once = 0;
	if (g_once_init_enter (&xnp_icon_button_type_id__once)) {
		GType xnp_icon_button_type_id;
		xnp_icon_button_type_id = xnp_icon_button_get_type_once ();
		g_once_init_leave (&xnp_icon_button_type_id__once, xnp_icon_button_type_id);
	}
	return xnp_icon_button_type_id__once;
}

static GType
xnp_title_bar_button_type_get_type_once (void)
{
	static const GEnumValue values[] = {{XNP_TITLE_BAR_BUTTON_TYPE_EMPTY, "XNP_TITLE_BAR_BUTTON_TYPE_EMPTY", "empty"}, {XNP_TITLE_BAR_BUTTON_TYPE_CLOSE, "XNP_TITLE_BAR_BUTTON_TYPE_CLOSE", "close"}, {XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW, "XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW", "left-arrow"}, {XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW, "XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW", "right-arrow"}, {XNP_TITLE_BAR_BUTTON_TYPE_REFRESH, "XNP_TITLE_BAR_BUTTON_TYPE_REFRESH", "refresh"}, {0, NULL, NULL}};
	GType xnp_title_bar_button_type_type_id;
	xnp_title_bar_button_type_type_id = g_enum_register_static ("XnpTitleBarButtonType", values);
	return xnp_title_bar_button_type_type_id;
}

GType
xnp_title_bar_button_type_get_type (void)
{
	static volatile gsize xnp_title_bar_button_type_type_id__once = 0;
	if (g_once_init_enter (&xnp_title_bar_button_type_type_id__once)) {
		GType xnp_title_bar_button_type_type_id;
		xnp_title_bar_button_type_type_id = xnp_title_bar_button_type_get_type_once ();
		g_once_init_leave (&xnp_title_bar_button_type_type_id__once, xnp_title_bar_button_type_type_id);
	}
	return xnp_title_bar_button_type_type_id__once;
}

static inline gpointer
xnp_title_bar_button_get_instance_private (XnpTitleBarButton* self)
{
	return G_STRUCT_MEMBER_P (self, XnpTitleBarButton_private_offset);
}

XnpTitleBarButton*
xnp_title_bar_button_construct (GType object_type,
                                XnpTitleBarButtonType icon_type)
{
	XnpTitleBarButton * self = NULL;
	self = (XnpTitleBarButton*) g_object_new (object_type, "icon-type", icon_type, NULL);
	return self;
}

XnpTitleBarButton*
xnp_title_bar_button_new (XnpTitleBarButtonType icon_type)
{
	return xnp_title_bar_button_construct (XNP_TYPE_TITLE_BAR_BUTTON, icon_type);
}

static void
xnp_title_bar_button_real_draw_icon (XnpIconButton* base,
                                     cairo_t* cr,
                                     gint width,
                                     gint height)
{
	XnpTitleBarButton * self;
	XnpTitleBarButtonType _tmp0_;
	self = (XnpTitleBarButton*) base;
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->_icon_type;
	switch (_tmp0_) {
		case XNP_TITLE_BAR_BUTTON_TYPE_CLOSE:
		{
			xnp_title_bar_button_draw_close_button (self, cr, width, height);
			break;
		}
		case XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW:
		{
			xnp_title_bar_button_draw_left_arrow_button (self, cr, width, height);
			break;
		}
		case XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW:
		{
			xnp_title_bar_button_draw_right_arrow_button (self, cr, width, height);
			break;
		}
		case XNP_TITLE_BAR_BUTTON_TYPE_REFRESH:
		{
			xnp_title_bar_button_draw_refresh_button (self, cr, width, height);
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
xnp_title_bar_button_draw_left_arrow_button (XnpTitleBarButton* self,
                                             cairo_t* cr,
                                             gint width,
                                             gint height)
{
	gint border = 0;
	gint x1 = 0;
	gint x2 = 0;
	gint y1 = 0;
	gint y2 = 0;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	border = 4;
	x1 = border;
	x2 = width - border;
	y1 = border;
	y2 = height - border;
	if (x2 <= x1) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = y2 <= y1;
	}
	if (_tmp0_) {
		return;
	}
	cairo_set_line_cap (cr, CAIRO_LINE_CAP_ROUND);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 2)) {
					break;
				}
				if (i == 0) {
					gdouble _tmp3_ = 0.0;
					if (((XnpIconButton*) self)->active) {
						_tmp3_ = 0.4;
					} else {
						_tmp3_ = 0.2;
					}
					cairo_set_source_rgba (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1, _tmp3_);
					cairo_set_line_width (cr, (gdouble) 4);
				} else {
					xnp_icon_button_set_widget_source_color ((XnpIconButton*) self, cr);
					cairo_set_line_width (cr, 2.66);
				}
				cairo_move_to (cr, (gdouble) x1, (gdouble) (height / 2));
				cairo_line_to (cr, (gdouble) x2, (gdouble) (height / 2));
				cairo_move_to (cr, (gdouble) (width / 2), (gdouble) y1);
				cairo_line_to (cr, (gdouble) x1, (gdouble) (height / 2));
				cairo_line_to (cr, (gdouble) (width / 2), (gdouble) y2);
				cairo_stroke (cr);
			}
		}
	}
}

static void
xnp_title_bar_button_draw_right_arrow_button (XnpTitleBarButton* self,
                                              cairo_t* cr,
                                              gint width,
                                              gint height)
{
	gint border = 0;
	gint x1 = 0;
	gint x2 = 0;
	gint y1 = 0;
	gint y2 = 0;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	border = 4;
	x1 = border;
	x2 = width - border;
	y1 = border;
	y2 = height - border;
	if (x2 <= x1) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = y2 <= y1;
	}
	if (_tmp0_) {
		return;
	}
	cairo_set_line_cap (cr, CAIRO_LINE_CAP_ROUND);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 2)) {
					break;
				}
				if (i == 0) {
					gdouble _tmp3_ = 0.0;
					if (((XnpIconButton*) self)->active) {
						_tmp3_ = 0.4;
					} else {
						_tmp3_ = 0.2;
					}
					cairo_set_source_rgba (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1, _tmp3_);
					cairo_set_line_width (cr, (gdouble) 4);
				} else {
					xnp_icon_button_set_widget_source_color ((XnpIconButton*) self, cr);
					cairo_set_line_width (cr, 2.66);
				}
				cairo_move_to (cr, (gdouble) x1, (gdouble) (height / 2));
				cairo_line_to (cr, (gdouble) x2, (gdouble) (height / 2));
				cairo_move_to (cr, (gdouble) (width / 2), (gdouble) y1);
				cairo_line_to (cr, (gdouble) x2, (gdouble) (height / 2));
				cairo_line_to (cr, (gdouble) (width / 2), (gdouble) y2);
				cairo_stroke (cr);
			}
		}
	}
}

static void
xnp_title_bar_button_draw_close_button (XnpTitleBarButton* self,
                                        cairo_t* cr,
                                        gint width,
                                        gint height)
{
	gint border = 0;
	gint x1 = 0;
	gint x2 = 0;
	gint y1 = 0;
	gint y2 = 0;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	border = 4;
	x1 = border;
	x2 = width - border;
	y1 = border;
	y2 = height - border;
	if (x2 <= x1) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = y2 <= y1;
	}
	if (_tmp0_) {
		return;
	}
	cairo_set_line_cap (cr, CAIRO_LINE_CAP_ROUND);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 2)) {
					break;
				}
				if (i == 0) {
					gdouble _tmp3_ = 0.0;
					if (((XnpIconButton*) self)->active) {
						_tmp3_ = 0.4;
					} else {
						_tmp3_ = 0.2;
					}
					cairo_set_source_rgba (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1, _tmp3_);
					cairo_set_line_width (cr, (gdouble) 4);
				} else {
					xnp_icon_button_set_widget_source_color ((XnpIconButton*) self, cr);
					cairo_set_line_width (cr, 2.66);
				}
				cairo_move_to (cr, (gdouble) x1, (gdouble) y1);
				cairo_line_to (cr, (gdouble) x2, (gdouble) y2);
				cairo_move_to (cr, (gdouble) x2, (gdouble) y1);
				cairo_line_to (cr, (gdouble) x1, (gdouble) y2);
				cairo_stroke (cr);
			}
		}
	}
}

static void
xnp_title_bar_button_draw_refresh_button (XnpTitleBarButton* self,
                                          cairo_t* cr,
                                          gint width,
                                          gint height)
{
	gint border = 0;
	gint x1 = 0;
	gint x2 = 0;
	gint y1 = 0;
	gint y2 = 0;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	border = 6;
	x1 = border;
	x2 = width - border;
	y1 = border;
	y2 = height - border;
	if (x2 <= x1) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = y2 <= y1;
	}
	if (_tmp0_) {
		return;
	}
	cairo_set_line_cap (cr, CAIRO_LINE_CAP_ROUND);
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = j;
					j = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(j < 2)) {
					break;
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gdouble r = 0.0;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = i;
								i = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(i < 2)) {
								break;
							}
							if (i == 0) {
								gdouble _tmp5_ = 0.0;
								if (((XnpIconButton*) self)->active) {
									_tmp5_ = 0.4;
								} else {
									_tmp5_ = 0.2;
								}
								cairo_set_source_rgba (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1, _tmp5_);
								cairo_set_line_width (cr, (gdouble) 4);
							} else {
								xnp_icon_button_set_widget_source_color ((XnpIconButton*) self, cr);
								cairo_set_line_width (cr, 2.44);
							}
							cairo_save (cr);
							cairo_translate (cr, (gdouble) (x1 + ((x2 - x1) / 2)), (gdouble) (y1 + ((y2 - y1) / 2)));
							if (j == 0) {
								cairo_rotate (cr, (-M_PI) / 16.0);
							} else {
								cairo_rotate (cr, (15.0 * M_PI) / 16.0);
							}
							cairo_arc (cr, (gdouble) 0, (gdouble) 0, (gdouble) (x2 - x1), (5.0 * M_PI) / 16.0, M_PI);
							r = (x2 - x1) / 2.0;
							cairo_line_to (cr, (-r) * 2.0, (3.0 * r) / 2.0);
							cairo_move_to (cr, (-r) * 2.0, 0.0);
							cairo_line_to (cr, -r, r / 2.0);
							cairo_stroke (cr);
							cairo_restore (cr);
						}
					}
				}
			}
		}
	}
}

XnpTitleBarButtonType
xnp_title_bar_button_get_icon_type (XnpTitleBarButton* self)
{
	XnpTitleBarButtonType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_icon_type;
	return result;
}

void
xnp_title_bar_button_set_icon_type (XnpTitleBarButton* self,
                                    XnpTitleBarButtonType value)
{
	XnpTitleBarButtonType old_value;
	g_return_if_fail (self != NULL);
	old_value = xnp_title_bar_button_get_icon_type (self);
	if (old_value != value) {
		self->priv->_icon_type = value;
		g_object_notify_by_pspec ((GObject *) self, xnp_title_bar_button_properties[XNP_TITLE_BAR_BUTTON_ICON_TYPE_PROPERTY]);
	}
}

static void
xnp_title_bar_button_class_init (XnpTitleBarButtonClass * klass,
                                 gpointer klass_data)
{
	xnp_title_bar_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XnpTitleBarButton_private_offset);
	((XnpIconButtonClass *) klass)->draw_icon = (void (*) (XnpIconButton*, cairo_t*, gint, gint)) xnp_title_bar_button_real_draw_icon;
	G_OBJECT_CLASS (klass)->get_property = _vala_xnp_title_bar_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_xnp_title_bar_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = xnp_title_bar_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_TITLE_BAR_BUTTON_ICON_TYPE_PROPERTY, xnp_title_bar_button_properties[XNP_TITLE_BAR_BUTTON_ICON_TYPE_PROPERTY] = g_param_spec_enum ("icon-type", "icon-type", "icon-type", XNP_TYPE_TITLE_BAR_BUTTON_TYPE, XNP_TITLE_BAR_BUTTON_TYPE_EMPTY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
xnp_title_bar_button_instance_init (XnpTitleBarButton * self,
                                    gpointer klass)
{
	self->priv = xnp_title_bar_button_get_instance_private (self);
	self->priv->_icon_type = XNP_TITLE_BAR_BUTTON_TYPE_EMPTY;
}

static void
xnp_title_bar_button_finalize (GObject * obj)
{
	XnpTitleBarButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButton);
	G_OBJECT_CLASS (xnp_title_bar_button_parent_class)->finalize (obj);
}

static GType
xnp_title_bar_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XnpTitleBarButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_title_bar_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpTitleBarButton), 0, (GInstanceInitFunc) xnp_title_bar_button_instance_init, NULL };
	GType xnp_title_bar_button_type_id;
	xnp_title_bar_button_type_id = g_type_register_static (XNP_TYPE_ICON_BUTTON, "XnpTitleBarButton", &g_define_type_info, 0);
	XnpTitleBarButton_private_offset = g_type_add_instance_private (xnp_title_bar_button_type_id, sizeof (XnpTitleBarButtonPrivate));
	return xnp_title_bar_button_type_id;
}

GType
xnp_title_bar_button_get_type (void)
{
	static volatile gsize xnp_title_bar_button_type_id__once = 0;
	if (g_once_init_enter (&xnp_title_bar_button_type_id__once)) {
		GType xnp_title_bar_button_type_id;
		xnp_title_bar_button_type_id = xnp_title_bar_button_get_type_once ();
		g_once_init_leave (&xnp_title_bar_button_type_id__once, xnp_title_bar_button_type_id);
	}
	return xnp_title_bar_button_type_id__once;
}

static void
_vala_xnp_title_bar_button_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	XnpTitleBarButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButton);
	switch (property_id) {
		case XNP_TITLE_BAR_BUTTON_ICON_TYPE_PROPERTY:
		g_value_set_enum (value, xnp_title_bar_button_get_icon_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_xnp_title_bar_button_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	XnpTitleBarButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButton);
	switch (property_id) {
		case XNP_TITLE_BAR_BUTTON_ICON_TYPE_PROPERTY:
		xnp_title_bar_button_set_icon_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

