.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
pulsar - intersecting planes, alpha blending, fog, and textures.
.SH SYNOPSIS
.B pulsar
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-no-light]
[\-wire]
[\-delay \fInumber\fP]
[\-quads \fInumber\fP]
[\-image \fIfile\fP]
[\-light]
[\-fog]
[\-texture]
[\-mipmap]
[\-no-blend]
[\-antialias]
[\-texture_quality]
[\-do_depth]
[\-fps]
.SH DESCRIPTION
Draws some intersecting planes, making use of alpha blending, fog,
textures, and mipmaps, plus a ``frames per second'' meter so that you can
tell how fast your graphics card is... Requires OpenGL.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-light | \-no-light
Use Flat Coloring.
.TP 8
.B \-wire
Render in wireframe instead of solid.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 10000 (0.01 seconds.).
.TP 8
.B \-image \fIfile\fP
The texture map to use.
.TP 8
.B \-quads \fInumber\fP
Quad Count.  1 - 50.  Default: 5.
.TP 8
.B \-light | \-no-light
Whether to enable lighting.
.TP 8
.B \-fog | \-no-fog
Whether to enable fog.
.TP 8
.B \-texture | \-no-texture
Whether to enable texturing.
.TP 8
.B \-mipmap | \-no-mipmap
Whether to enable texture mipmaps.
.TP 8
.B \-blend | \-no-blend
Whether to enable blending.
.TP 8
.B \-antialias | \-no-antialias
Whether to anti-alias lines.
.TP 8
.B \-texture_quality | \-no-texture_quality
Whether to enable texture filtering.
.TP 8
.B \-do_depth | \-no-do_depth
Whether to enable depth buffer.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2002 by David Konerding.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
David Konerding.
