# Automatic dependency flow

During a build, the orchestrator must provide each repo build with outputs and information from its upstream builds so that the end result is a full product. This is automatic dependency flow.

 * [`api.md`](api.md): Lists Repo API arguments a repo must accept to participate in auto dependency flow.
 * [`example.md`](example.md): Shows example implementations that can be used as guidance.

## Terms
*[Product] Dependency*: an artifact generated by one repo build that is required for a downstream repo build. "Product" is assumed, but may be used to clarify vs. a toolset dependency.

*Full product*: a set of repository build outputs that are coherent. As opposed to "isolated products" which have uncoordinated dependency versions that may conflict.

*Isolated build*: a build that a repo performs independently. The repo chooses its own dependencies, usually pinning to specific versions to isolate itself from breaking changes until they can be taken. This type of build is performed for short-term productivity, and it doesn't affect the product build or source build. These builds are the "old way" of shipping the .NET Core product: the dependencies "roll up" in a series of isolated builds to form the full product.

*Product build*: a build that produced a *full product* for all platforms Microsoft ships.

*Source build*: a build that doesn't depend on any external pre-built dependencies to produce a *full product* for a specific platform. AKA "build from source".

*Orchestrator*: the system that keeps track of all repos involved in a build and performs the steps necessary to coordinate the build process. This doc assumes the orchestrator has some control over the machine(s) being built on: at minimum, downloading files to disk and customizing build command args. The orchestrator is involved in source builds and product builds, but not the isolated builds.

*Repo build*: a particular repository's build that the orchestrator orchestrates. If building the repo involves multiple build legs (e.g. to build native bits on different platforms), all legs together are called *a* repo build.

*Blob feed*: a structured directory of build outputs. AKA "transport feed". Summary of important details for auto dependency flow:

 * There is one blob feed per product build. Repo builds add to the single blob feed.
 * The orchestrator makes the blob feed available to all repo builds.
 * The blob feed is on disk or in blob storage virtual directories, but in general it has the same structure either way.

*Upstream/Downstream*: when dicussing repo A, repo B is "upstream" if A has a dependency on product outputs from B. Only repos built by the orchestrator are included. For example, in this doc, external toolsets aren't considered upstream from any repository, nor are any redistributed libraries that we don't build ourselves.


# Inserting dependency changes

The dependency change flow is shared by all builds that involve the orchestrator.

TL;DR: the orchestrator derives package version props from the blob feed after each repo build and feeds the data into all subsequent repo builds.

## Vision: product build end-to-end
This narrative describes an end-to-end Core-Setup (Runtime) product build using CoreFX, CoreCLR, and Standard. More repos will be involved in real product builds.

The orchestrator starts by calculating a repo dependency graph. Edges are determined using repo-to-repo dependency metadata stored and maintained in the source-build repository. The graph is a DAG, so it's buildable. In this case, we have:

 * Core-Setup
   * CoreFX
     * CoreCLR
     * Standard

The orchestrator sees that CoreCLR and Standard are leaves and kicks off both repo builds. Packages produced [end up on the blob feed](#blob-feed) when they're finished, and CoreCLR and Standard are removed from the graph.

 * Core-Setup
   * CoreFX

CoreFX is the next leaf, so it will be built next. The orchestrator [creates the package version props based on the blob feed and passes it](#-passing-dependency-versions) into a repo build of CoreFX. CoreFX uses the file to determine which package versions to use, and consumes them from the blob feed. The repo build completes and the CoreFX leaf is removed.

 * Core-Setup

The process repeats for the next leaf, Core-Setup: the orchestrator creates the build output props and passes it into a Core-Setup repo build. The Core-Setup build finishes, outputting to the blob feed, and the Core-Setup leaf is removed.

There are no more nodes: the repo builds are complete! The blob feed contains all the product outputs. The orchestrator performs finalization steps (testing, publishing) and then the product build is complete.

### Incremental steps toward the vision
The narrative represents the ideal flow, and some parts won't be available in our first steps:

 * The CoreCLR and Standard builds may not be run in parallel.
 * The orchestrator might not have any finalization steps. Instead, they happen during the repo builds. 

## Blob feed
The orchestrator indicates a directory on the build machine to place output files using [`-p:DotNetOutputBlobFeedDir`](api.md#-pdotnetoutputblobfeeddirtarget-directory). The orchestrator makes the contents available to subsequent repo builds using [`-p:DotNetRestoreSourcePropsPath`](api.md#-pdotnetrestoresourcepropspathpath) and [`-p:DotNetAssetRootUrl`](api.md#-pdotnetassetrooturlurl).

## Passing dependency versions
To pass the upstream NuGet package versions to use, the orchestrator creates a "package version props" file based on the current blob feed contents and passes it with [`-p:DotNetPackageVersionPropsPath=<path>`](api.md#-pdotnetpackageversionpropspathpath).

Additional API surface area for dependency passing may be added in the future, based on need. For example:

   * Native-only repo builds may require a simpler format to reasonably parse.
   * Additional MSBuild props files may be added to flow non-package dependencies.


# Source build vs. product build dependency flow

Source build has some requirements that don't necessarily apply to the product build: it must avoid dependencies on prebuilt dependencies and [rebuild without using the prebuilt version ("bootstrap")](https://fedoraproject.org/wiki/Packaging:Guidelines#Bootstrapping) where that's not possible. This separates the product build and source build in a few ways relevant to auto dependency flow.

## Latest Target Framework Monikers (TFMs)
E.g. upgrading to netstandard2.0, netcoreapp2.1.

For product builds, we want to allow the repos continue to depend on the oldest possible TFM to give the product greater reach. Specifically, Visual Studio targets old netstandard TFMs.

For source builds, upgrading TFMs allows the repos to avoid depending on old package versions. They would also need to be built from source.

The [`-p:DotNetSourceBuildTargetFrameworkPropsPath`](api.md#-pdotnetsourcebuildtargetframeworkpropspathpath) API is used during source builds to pass the TFM being built.

## Upgrading all tooling dependencies we build to the latest
This is *required* for build from source to satisfy bootstrapping requirements, and *desired* (mildly) for product builds in order to dogfood.
