# Downloading and viewing results and reports - [Results API](../README.md#results-api)

There are multiple methods to download or view reports generated by the WPT 
Report tool or just the plain json results with the structure as described in 
the [`create`](./create.md) method of the results API.

## 1. `download`

Downloads all results of a session as ZIP, which other instances of the WMAS 
Test Suite can import.

### HTTP Request

`GET /api/results/<session_token>/export`

### Example

`GET /api/results/f63700a0-c35f-11e9-af33-9e0d4c1f1370/export`

## 2. `download api`

Downloads all results of a single API in one json file.

### HTTP Request

`GET /api/results/<session_token>/<api_name>/json`

### File Structure

```json
{
  "results": [
    {
      "test": "String",
      "status": "Enum['OK', 'ERROR', 'TIMEOUT', 'NOT_RUN']",
      "message": "String",
      "subtests": [
        {
          "name": "String",
          "status": "Enum['PASS', 'FAIL', 'TIMEOUT', 'NOT_RUN']",
          "message": "String"
        }
      ]
    }
  ]
}
```

Results are structured as explained in the [`create`](./create.md) method of the results API.

### Example

`GET /api/results/f63700a0-c35f-11e9-af33-9e0d4c1f1370/apiOne/json`

## 3. `download all apis`

Downloads all results of all APIs of a session as zip file containing one json file per API.

### HTTP Request

`GET /api/results/<session_token>/json`

### File Structure

There is one json file per API, each structured as described in the [`download api`](#download-api) method.

### Example

`GET /api/results/f63700a0-c35f-11e9-af33-9e0d4c1f1370/json`

## 4. `view report`

Returns a URL to a report of an API of a session, generated by the WPT Report tool, which is a static HTML page.

### HTTP Request

`GET /api/results/<session_token>/<api_name>/reporturl`

### Example

`GET /api/results/f63700a0-c35f-11e9-af33-9e0d4c1f1370/apiOne/reporturl`

**Response**

```json
{
    "uri": "/results/8f7f2fdc-62eb-11ea-8615-b8ca3a7b18ad/2dcontext/all.html"
}
```

## 5. `view multi report`

Returns a URL to a report of an API of multiple session, generated by the WPT Report tool, which is a static HTML page.

### HTTP Request

`GET /api/results/<api_name>/reporturl`

### Query Parameters

| Parameter | Description                                                  | Default | Example                          |
| --------- | ------------------------------------------------------------ | ------- | -------------------------------- |
| `tokens`  | Comma separated list of tokens to create a multi report for. | none    | `tokens=token_a,token_b,token_c` |

### Example

`GET /api/results/apiOne/reporturl?tokens=8f7f2fdc-62eb-11ea-8615-b8ca3a7b18ad,990b4734-62eb-11ea-a9a5-b8ca3a7b18ad`

**Response**

```json
{
    "uri": "/results/comparison-8f7f2fdc-990b473401488e04/reporturl/all.html"
}
```

## 6. `download overview`

Downloads a zip file containing an overview for all APIs results of a session as a static HTML page.

### HTTP Request

`GET /api/results/<session_token>/overview`

### Example

`GET /api/results/f63700a0-c35f-11e9-af33-9e0d4c1f1370/overview`
