/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.rhino.head.ast.Assignment;
import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.Comment;
import com.google.javascript.rhino.head.ast.FunctionNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.chromium.devtools.jsdoc.ValidationCheck;
import org.chromium.devtools.jsdoc.ValidatorContext;
import org.chromium.devtools.jsdoc.checks.AstUtil;
import org.chromium.devtools.jsdoc.checks.ContextTrackingChecker;
import org.chromium.devtools.jsdoc.checks.ContextTrackingState;
import org.chromium.devtools.jsdoc.checks.FunctionReceiverChecker;
import org.chromium.devtools.jsdoc.checks.FunctionRecord;
import org.chromium.devtools.jsdoc.checks.ProtoFollowsExtendsChecker;
import org.chromium.devtools.jsdoc.checks.ReturnAnnotationChecker;
import org.chromium.devtools.jsdoc.checks.TypeRecord;

public class ContextTrackingValidationCheck
extends ValidationCheck {
    private static final Pattern EXTENDS_PATTERN = Pattern.compile("@extends\\s+\\{\\s*([^\\s}]+)\\s*\\}");
    private static final Pattern RETURN_PATTERN = Pattern.compile("@return\\s+\\{\\s*(.+)\\s*\\}");
    private ContextTrackingState state;
    private final List<ContextTrackingChecker> clients = new ArrayList<ContextTrackingChecker>(5);

    @Override
    protected void setContext(ValidatorContext validatorContext) {
        super.setContext(validatorContext);
        this.state = new ContextTrackingState(validatorContext);
        this.registerClient(new ProtoFollowsExtendsChecker());
        this.registerClient(new ReturnAnnotationChecker());
        this.registerClient(new FunctionReceiverChecker());
    }

    @Override
    public void doVisit(AstNode astNode) {
        switch (astNode.getType()) {
            case 90: {
                this.enterAssignNode((Assignment)astNode);
                break;
            }
            case 109: {
                this.enterFunctionNode((FunctionNode)astNode);
                break;
            }
        }
        this.enterNode(astNode);
    }

    @Override
    public void didVisit(AstNode astNode) {
        this.leaveNode(astNode);
        switch (astNode.getType()) {
            case 90: {
                this.leaveAssignNode((Assignment)astNode);
                break;
            }
            case 109: {
                this.leaveFunctionNode((FunctionNode)astNode);
                break;
            }
        }
    }

    public void registerClient(ContextTrackingChecker contextTrackingChecker) {
        this.clients.add(contextTrackingChecker);
        contextTrackingChecker.setState(this.state);
    }

    private void enterNode(AstNode astNode) {
        for (ContextTrackingChecker contextTrackingChecker : this.clients) {
            contextTrackingChecker.enterNode(astNode);
        }
    }

    private void leaveNode(AstNode astNode) {
        for (ContextTrackingChecker contextTrackingChecker : this.clients) {
            contextTrackingChecker.leaveNode(astNode);
        }
    }

    private void enterFunctionNode(FunctionNode functionNode) {
        Comment comment = ContextTrackingValidationCheck.getJsDocNode(functionNode);
        AstNode astNode = AstUtil.getFunctionNameNode(functionNode);
        String string = this.getNodeText(astNode);
        boolean bl = string != null && this.rememberTypeRecordIfNeeded(string, comment);
        TypeRecord typeRecord = this.state.getCurrentFunctionRecord() == null ? this.state.getCurrentTypeRecord() : null;
        this.state.pushFunctionRecord(new FunctionRecord(functionNode, string, bl, this.getReturnType(comment), typeRecord, this.state.getCurrentFunctionRecord()));
    }

    private void leaveFunctionNode(FunctionNode functionNode) {
        this.state.functionRecords.removeLast();
    }

    private String getReturnType(Comment comment) {
        if (comment == null) {
            return null;
        }
        String string = this.getNodeText(comment);
        Matcher matcher = RETURN_PATTERN.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }

    private void enterAssignNode(Assignment assignment) {
        String string = this.getAssignedTypeName(assignment);
        if (string == null) {
            return;
        }
        if (AstUtil.isPrototypeName(string)) {
            String string2 = AstUtil.getTypeNameFromPrototype(string);
            TypeRecord typeRecord = this.state.typeRecordsByTypeName.get(string2);
            this.state.pushTypeRecord(typeRecord);
            this.state.pushFunctionRecord(null);
            return;
        }
        if (assignment.getRight().getType() == 109) {
            this.rememberTypeRecordIfNeeded(string, ContextTrackingValidationCheck.getJsDocNode(assignment));
        }
    }

    private void leaveAssignNode(Assignment assignment) {
        String string = this.getAssignedTypeName(assignment);
        if (string == null) {
            return;
        }
        if (AstUtil.isPrototypeName(string)) {
            this.state.typeRecords.removeLast();
            this.state.functionRecords.removeLast();
            return;
        }
    }

    private String getAssignedTypeName(Assignment assignment) {
        AstNode astNode = AstUtil.getAssignedTypeNameNode(assignment);
        return this.getNodeText(astNode);
    }

    private boolean rememberTypeRecordIfNeeded(String string, Comment comment) {
        String string2 = this.getNodeText(comment);
        if (!ContextTrackingValidationCheck.isConstructor(string2) && !ContextTrackingValidationCheck.isInterface(string2)) {
            return false;
        }
        TypeRecord typeRecord = new TypeRecord(string, ContextTrackingValidationCheck.isInterface(string2), this.getExtendsEntries(comment));
        this.state.typeRecordsByTypeName.put(string, typeRecord);
        return true;
    }

    private static boolean isInterface(String string) {
        return string != null && string.contains("@interface");
    }

    private static boolean isConstructor(String string) {
        return string != null && string.contains("@constructor");
    }

    private static Comment getJsDocNode(AstNode astNode) {
        if (astNode.getType() == 109) {
            return AstUtil.getJsDocNode((FunctionNode)astNode);
        }
        return astNode.getJsDocNode();
    }

    private List<TypeRecord.InheritanceEntry> getExtendsEntries(Comment comment) {
        if (comment == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeRecord.InheritanceEntry> arrayList = new ArrayList<TypeRecord.InheritanceEntry>(2);
        Matcher matcher = EXTENDS_PATTERN.matcher(this.getNodeText(comment));
        while (matcher.find()) {
            arrayList.add(new TypeRecord.InheritanceEntry(matcher.group(1), comment, matcher.start(1)));
        }
        return arrayList;
    }
}

