/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (c) 2013-2014, NVIDIA CORPORATION. All rights reserved.
 */

#ifndef _TEGRA124_PINMUX_H_
#define _TEGRA124_PINMUX_H_

enum pmux_pingrp {
	PMUX_PINGRP_ULPI_DATA0_PO1,
	PMUX_PINGRP_ULPI_DATA1_PO2,
	PMUX_PINGRP_ULPI_DATA2_PO3,
	PMUX_PINGRP_ULPI_DATA3_PO4,
	PMUX_PINGRP_ULPI_DATA4_PO5,
	PMUX_PINGRP_ULPI_DATA5_PO6,
	PMUX_PINGRP_ULPI_DATA6_PO7,
	PMUX_PINGRP_ULPI_DATA7_PO0,
	PMUX_PINGRP_ULPI_CLK_PY0,
	PMUX_PINGRP_ULPI_DIR_PY1,
	PMUX_PINGRP_ULPI_NXT_PY2,
	PMUX_PINGRP_ULPI_STP_PY3,
	PMUX_PINGRP_DAP3_FS_PP0,
	PMUX_PINGRP_DAP3_DIN_PP1,
	PMUX_PINGRP_DAP3_DOUT_PP2,
	PMUX_PINGRP_DAP3_SCLK_PP3,
	PMUX_PINGRP_PV0,
	PMUX_PINGRP_PV1,
	PMUX_PINGRP_SDMMC1_CLK_PZ0,
	PMUX_PINGRP_SDMMC1_CMD_PZ1,
	PMUX_PINGRP_SDMMC1_DAT3_PY4,
	PMUX_PINGRP_SDMMC1_DAT2_PY5,
	PMUX_PINGRP_SDMMC1_DAT1_PY6,
	PMUX_PINGRP_SDMMC1_DAT0_PY7,
	PMUX_PINGRP_CLK2_OUT_PW5 = (0x68 / 4),
	PMUX_PINGRP_CLK2_REQ_PCC5,
	PMUX_PINGRP_HDMI_INT_PN7 = (0x110 / 4),
	PMUX_PINGRP_DDC_SCL_PV4,
	PMUX_PINGRP_DDC_SDA_PV5,
	PMUX_PINGRP_UART2_RXD_PC3 = (0x164 / 4),
	PMUX_PINGRP_UART2_TXD_PC2,
	PMUX_PINGRP_UART2_RTS_N_PJ6,
	PMUX_PINGRP_UART2_CTS_N_PJ5,
	PMUX_PINGRP_UART3_TXD_PW6,
	PMUX_PINGRP_UART3_RXD_PW7,
	PMUX_PINGRP_UART3_CTS_N_PA1,
	PMUX_PINGRP_UART3_RTS_N_PC0,
	PMUX_PINGRP_PU0,
	PMUX_PINGRP_PU1,
	PMUX_PINGRP_PU2,
	PMUX_PINGRP_PU3,
	PMUX_PINGRP_PU4,
	PMUX_PINGRP_PU5,
	PMUX_PINGRP_PU6,
	PMUX_PINGRP_GEN1_I2C_SDA_PC5,
	PMUX_PINGRP_GEN1_I2C_SCL_PC4,
	PMUX_PINGRP_DAP4_FS_PP4,
	PMUX_PINGRP_DAP4_DIN_PP5,
	PMUX_PINGRP_DAP4_DOUT_PP6,
	PMUX_PINGRP_DAP4_SCLK_PP7,
	PMUX_PINGRP_CLK3_OUT_PEE0,
	PMUX_PINGRP_CLK3_REQ_PEE1,
	PMUX_PINGRP_PC7,
	PMUX_PINGRP_PI5,
	PMUX_PINGRP_PI7,
	PMUX_PINGRP_PK0,
	PMUX_PINGRP_PK1,
	PMUX_PINGRP_PJ0,
	PMUX_PINGRP_PJ2,
	PMUX_PINGRP_PK3,
	PMUX_PINGRP_PK4,
	PMUX_PINGRP_PK2,
	PMUX_PINGRP_PI3,
	PMUX_PINGRP_PI6,
	PMUX_PINGRP_PG0,
	PMUX_PINGRP_PG1,
	PMUX_PINGRP_PG2,
	PMUX_PINGRP_PG3,
	PMUX_PINGRP_PG4,
	PMUX_PINGRP_PG5,
	PMUX_PINGRP_PG6,
	PMUX_PINGRP_PG7,
	PMUX_PINGRP_PH0,
	PMUX_PINGRP_PH1,
	PMUX_PINGRP_PH2,
	PMUX_PINGRP_PH3,
	PMUX_PINGRP_PH4,
	PMUX_PINGRP_PH5,
	PMUX_PINGRP_PH6,
	PMUX_PINGRP_PH7,
	PMUX_PINGRP_PJ7,
	PMUX_PINGRP_PB0,
	PMUX_PINGRP_PB1,
	PMUX_PINGRP_PK7,
	PMUX_PINGRP_PI0,
	PMUX_PINGRP_PI1,
	PMUX_PINGRP_PI2,
	PMUX_PINGRP_PI4,
	PMUX_PINGRP_GEN2_I2C_SCL_PT5,
	PMUX_PINGRP_GEN2_I2C_SDA_PT6,
	PMUX_PINGRP_SDMMC4_CLK_PCC4,
	PMUX_PINGRP_SDMMC4_CMD_PT7,
	PMUX_PINGRP_SDMMC4_DAT0_PAA0,
	PMUX_PINGRP_SDMMC4_DAT1_PAA1,
	PMUX_PINGRP_SDMMC4_DAT2_PAA2,
	PMUX_PINGRP_SDMMC4_DAT3_PAA3,
	PMUX_PINGRP_SDMMC4_DAT4_PAA4,
	PMUX_PINGRP_SDMMC4_DAT5_PAA5,
	PMUX_PINGRP_SDMMC4_DAT6_PAA6,
	PMUX_PINGRP_SDMMC4_DAT7_PAA7,
	PMUX_PINGRP_CAM_MCLK_PCC0 = (0x284 / 4),
	PMUX_PINGRP_PCC1,
	PMUX_PINGRP_PBB0,
	PMUX_PINGRP_CAM_I2C_SCL_PBB1,
	PMUX_PINGRP_CAM_I2C_SDA_PBB2,
	PMUX_PINGRP_PBB3,
	PMUX_PINGRP_PBB4,
	PMUX_PINGRP_PBB5,
	PMUX_PINGRP_PBB6,
	PMUX_PINGRP_PBB7,
	PMUX_PINGRP_PCC2,
	PMUX_PINGRP_JTAG_RTCK,
	PMUX_PINGRP_PWR_I2C_SCL_PZ6,
	PMUX_PINGRP_PWR_I2C_SDA_PZ7,
	PMUX_PINGRP_KB_ROW0_PR0,
	PMUX_PINGRP_KB_ROW1_PR1,
	PMUX_PINGRP_KB_ROW2_PR2,
	PMUX_PINGRP_KB_ROW3_PR3,
	PMUX_PINGRP_KB_ROW4_PR4,
	PMUX_PINGRP_KB_ROW5_PR5,
	PMUX_PINGRP_KB_ROW6_PR6,
	PMUX_PINGRP_KB_ROW7_PR7,
	PMUX_PINGRP_KB_ROW8_PS0,
	PMUX_PINGRP_KB_ROW9_PS1,
	PMUX_PINGRP_KB_ROW10_PS2,
	PMUX_PINGRP_KB_ROW11_PS3,
	PMUX_PINGRP_KB_ROW12_PS4,
	PMUX_PINGRP_KB_ROW13_PS5,
	PMUX_PINGRP_KB_ROW14_PS6,
	PMUX_PINGRP_KB_ROW15_PS7,
	PMUX_PINGRP_KB_COL0_PQ0,
	PMUX_PINGRP_KB_COL1_PQ1,
	PMUX_PINGRP_KB_COL2_PQ2,
	PMUX_PINGRP_KB_COL3_PQ3,
	PMUX_PINGRP_KB_COL4_PQ4,
	PMUX_PINGRP_KB_COL5_PQ5,
	PMUX_PINGRP_KB_COL6_PQ6,
	PMUX_PINGRP_KB_COL7_PQ7,
	PMUX_PINGRP_CLK_32K_OUT_PA0,
	PMUX_PINGRP_CORE_PWR_REQ = (0x324 / 4),
	PMUX_PINGRP_CPU_PWR_REQ,
	PMUX_PINGRP_PWR_INT_N,
	PMUX_PINGRP_CLK_32K_IN,
	PMUX_PINGRP_OWR,
	PMUX_PINGRP_DAP1_FS_PN0,
	PMUX_PINGRP_DAP1_DIN_PN1,
	PMUX_PINGRP_DAP1_DOUT_PN2,
	PMUX_PINGRP_DAP1_SCLK_PN3,
	PMUX_PINGRP_DAP_MCLK1_REQ_PEE2,
	PMUX_PINGRP_DAP_MCLK1_PW4,
	PMUX_PINGRP_SPDIF_IN_PK6,
	PMUX_PINGRP_SPDIF_OUT_PK5,
	PMUX_PINGRP_DAP2_FS_PA2,
	PMUX_PINGRP_DAP2_DIN_PA4,
	PMUX_PINGRP_DAP2_DOUT_PA5,
	PMUX_PINGRP_DAP2_SCLK_PA3,
	PMUX_PINGRP_DVFS_PWM_PX0,
	PMUX_PINGRP_GPIO_X1_AUD_PX1,
	PMUX_PINGRP_GPIO_X3_AUD_PX3,
	PMUX_PINGRP_DVFS_CLK_PX2,
	PMUX_PINGRP_GPIO_X4_AUD_PX4,
	PMUX_PINGRP_GPIO_X5_AUD_PX5,
	PMUX_PINGRP_GPIO_X6_AUD_PX6,
	PMUX_PINGRP_GPIO_X7_AUD_PX7,
	PMUX_PINGRP_SDMMC3_CLK_PA6 = (0x390 / 4),
	PMUX_PINGRP_SDMMC3_CMD_PA7,
	PMUX_PINGRP_SDMMC3_DAT0_PB7,
	PMUX_PINGRP_SDMMC3_DAT1_PB6,
	PMUX_PINGRP_SDMMC3_DAT2_PB5,
	PMUX_PINGRP_SDMMC3_DAT3_PB4,
	PMUX_PINGRP_PEX_L0_RST_N_PDD1 = (0x3bc / 4),
	PMUX_PINGRP_PEX_L0_CLKREQ_N_PDD2,
	PMUX_PINGRP_PEX_WAKE_N_PDD3,
	PMUX_PINGRP_PEX_L1_RST_N_PDD5 = (0x3cc / 4),
	PMUX_PINGRP_PEX_L1_CLKREQ_N_PDD6,
	PMUX_PINGRP_HDMI_CEC_PEE3 = (0x3e0 / 4),
	PMUX_PINGRP_SDMMC1_WP_N_PV3,
	PMUX_PINGRP_SDMMC3_CD_N_PV2,
	PMUX_PINGRP_GPIO_W2_AUD_PW2,
	PMUX_PINGRP_GPIO_W3_AUD_PW3,
	PMUX_PINGRP_USB_VBUS_EN0_PN4,
	PMUX_PINGRP_USB_VBUS_EN1_PN5,
	PMUX_PINGRP_SDMMC3_CLK_LB_IN_PEE5,
	PMUX_PINGRP_SDMMC3_CLK_LB_OUT_PEE4,
	PMUX_PINGRP_GMI_CLK_LB,
	PMUX_PINGRP_RESET_OUT_N,
	PMUX_PINGRP_KB_ROW16_PT0,
	PMUX_PINGRP_KB_ROW17_PT1,
	PMUX_PINGRP_USB_VBUS_EN2_PFF1,
	PMUX_PINGRP_PFF2,
	PMUX_PINGRP_DP_HPD_PFF0 = (0x430 / 4),
	PMUX_PINGRP_COUNT,
};

enum pmux_drvgrp {
	PMUX_DRVGRP_AO1,
	PMUX_DRVGRP_AO2,
	PMUX_DRVGRP_AT1,
	PMUX_DRVGRP_AT2,
	PMUX_DRVGRP_AT3,
	PMUX_DRVGRP_AT4,
	PMUX_DRVGRP_AT5,
	PMUX_DRVGRP_CDEV1,
	PMUX_DRVGRP_CDEV2,
	PMUX_DRVGRP_DAP1 = (0x28 / 4),
	PMUX_DRVGRP_DAP2,
	PMUX_DRVGRP_DAP3,
	PMUX_DRVGRP_DAP4,
	PMUX_DRVGRP_DBG,
	PMUX_DRVGRP_SDIO3 = (0x48 / 4),
	PMUX_DRVGRP_SPI,
	PMUX_DRVGRP_UAA,
	PMUX_DRVGRP_UAB,
	PMUX_DRVGRP_UART2,
	PMUX_DRVGRP_UART3,
	PMUX_DRVGRP_SDIO1 = (0x84 / 4),
	PMUX_DRVGRP_DDC = (0x94 / 4),
	PMUX_DRVGRP_GMA,
	PMUX_DRVGRP_GME = (0xa8 / 4),
	PMUX_DRVGRP_GMF,
	PMUX_DRVGRP_GMG,
	PMUX_DRVGRP_GMH,
	PMUX_DRVGRP_OWR,
	PMUX_DRVGRP_UDA,
	PMUX_DRVGRP_GPV,
	PMUX_DRVGRP_DEV3,
	PMUX_DRVGRP_CEC = (0xd0 / 4),
	PMUX_DRVGRP_AT6 = (0x12c / 4),
	PMUX_DRVGRP_DAP5,
	PMUX_DRVGRP_USB_VBUS_EN,
	PMUX_DRVGRP_AO3 = (0x140 / 4),
	PMUX_DRVGRP_AO0 = (0x148 / 4),
	PMUX_DRVGRP_HV0,
	PMUX_DRVGRP_SDIO4 = (0x15c / 4),
	PMUX_DRVGRP_AO4,
	PMUX_DRVGRP_COUNT,
};

enum pmux_mipipadctrlgrp {
	PMUX_MIPIPADCTRLGRP_DSI_B,
	PMUX_MIPIPADCTRLGRP_COUNT,
};

enum pmux_func {
	PMUX_FUNC_DEFAULT,
	PMUX_FUNC_BLINK,
	PMUX_FUNC_CCLA,
	PMUX_FUNC_CEC,
	PMUX_FUNC_CLDVFS,
	PMUX_FUNC_CLK,
	PMUX_FUNC_CLK12,
	PMUX_FUNC_CPU,
	PMUX_FUNC_CSI,
	PMUX_FUNC_DAP,
	PMUX_FUNC_DAP1,
	PMUX_FUNC_DAP2,
	PMUX_FUNC_DEV3,
	PMUX_FUNC_DISPLAYA,
	PMUX_FUNC_DISPLAYA_ALT,
	PMUX_FUNC_DISPLAYB,
	PMUX_FUNC_DP,
	PMUX_FUNC_DSI_B,
	PMUX_FUNC_DTV,
	PMUX_FUNC_EXTPERIPH1,
	PMUX_FUNC_EXTPERIPH2,
	PMUX_FUNC_EXTPERIPH3,
	PMUX_FUNC_GMI,
	PMUX_FUNC_GMI_ALT,
	PMUX_FUNC_HDA,
	PMUX_FUNC_HSI,
	PMUX_FUNC_I2C1,
	PMUX_FUNC_I2C2,
	PMUX_FUNC_I2C3,
	PMUX_FUNC_I2C4,
	PMUX_FUNC_I2CPWR,
	PMUX_FUNC_I2S0,
	PMUX_FUNC_I2S1,
	PMUX_FUNC_I2S2,
	PMUX_FUNC_I2S3,
	PMUX_FUNC_I2S4,
	PMUX_FUNC_IRDA,
	PMUX_FUNC_KBC,
	PMUX_FUNC_OWR,
	PMUX_FUNC_PE,
	PMUX_FUNC_PE0,
	PMUX_FUNC_PE1,
	PMUX_FUNC_PMI,
	PMUX_FUNC_PWM0,
	PMUX_FUNC_PWM1,
	PMUX_FUNC_PWM2,
	PMUX_FUNC_PWM3,
	PMUX_FUNC_PWRON,
	PMUX_FUNC_RESET_OUT_N,
	PMUX_FUNC_RTCK,
	PMUX_FUNC_SATA,
	PMUX_FUNC_SDMMC1,
	PMUX_FUNC_SDMMC2,
	PMUX_FUNC_SDMMC3,
	PMUX_FUNC_SDMMC4,
	PMUX_FUNC_SOC,
	PMUX_FUNC_SPDIF,
	PMUX_FUNC_SPI1,
	PMUX_FUNC_SPI2,
	PMUX_FUNC_SPI3,
	PMUX_FUNC_SPI4,
	PMUX_FUNC_SPI5,
	PMUX_FUNC_SPI6,
	PMUX_FUNC_SYS,
	PMUX_FUNC_TMDS,
	PMUX_FUNC_TRACE,
	PMUX_FUNC_UARTA,
	PMUX_FUNC_UARTB,
	PMUX_FUNC_UARTC,
	PMUX_FUNC_UARTD,
	PMUX_FUNC_ULPI,
	PMUX_FUNC_USB,
	PMUX_FUNC_VGP1,
	PMUX_FUNC_VGP2,
	PMUX_FUNC_VGP3,
	PMUX_FUNC_VGP4,
	PMUX_FUNC_VGP5,
	PMUX_FUNC_VGP6,
	PMUX_FUNC_VI,
	PMUX_FUNC_VI_ALT1,
	PMUX_FUNC_VI_ALT3,
	PMUX_FUNC_VIMCLK2,
	PMUX_FUNC_VIMCLK2_ALT,
	PMUX_FUNC_RSVD1,
	PMUX_FUNC_RSVD2,
	PMUX_FUNC_RSVD3,
	PMUX_FUNC_RSVD4,
	PMUX_FUNC_COUNT,
};

static const char * const tegra_pinctrl_to_pingrp[] = {
	[PMUX_PINGRP_ULPI_DATA0_PO1] = "ulpi_data0_po1",
	[PMUX_PINGRP_ULPI_DATA1_PO2] = "ulpi_data1_po2",
	[PMUX_PINGRP_ULPI_DATA2_PO3] = "ulpi_data2_po3",
	[PMUX_PINGRP_ULPI_DATA3_PO4] = "ulpi_data3_po4",
	[PMUX_PINGRP_ULPI_DATA4_PO5] = "ulpi_data4_po5",
	[PMUX_PINGRP_ULPI_DATA5_PO6] = "ulpi_data5_po6",
	[PMUX_PINGRP_ULPI_DATA6_PO7] = "ulpi_data6_po7",
	[PMUX_PINGRP_ULPI_DATA7_PO0] = "ulpi_data7_po0",
	[PMUX_PINGRP_ULPI_CLK_PY0] = "ulpi_clk_py0",
	[PMUX_PINGRP_ULPI_DIR_PY1] = "ulpi_dir_py1",
	[PMUX_PINGRP_ULPI_NXT_PY2] = "ulpi_nxt_py2",
	[PMUX_PINGRP_ULPI_STP_PY3] = "ulpi_stp_py3",
	[PMUX_PINGRP_DAP3_FS_PP0] = "dap3_fs_pp0",
	[PMUX_PINGRP_DAP3_DIN_PP1] = "dap3_din_pp1",
	[PMUX_PINGRP_DAP3_DOUT_PP2] = "dap3_dout_pp2",
	[PMUX_PINGRP_DAP3_SCLK_PP3] = "dap3_sclk_pp3",
	[PMUX_PINGRP_PV0] = "pv0",
	[PMUX_PINGRP_PV1] = "pv1",
	[PMUX_PINGRP_SDMMC1_CLK_PZ0] = "sdmmc1_clk_pz0",
	[PMUX_PINGRP_SDMMC1_CMD_PZ1] = "sdmmc1_cmd_pz1",
	[PMUX_PINGRP_SDMMC1_DAT3_PY4] = "sdmmc1_dat3_py4",
	[PMUX_PINGRP_SDMMC1_DAT2_PY5] = "sdmmc1_dat2_py5",
	[PMUX_PINGRP_SDMMC1_DAT1_PY6] = "sdmmc1_dat1_py6",
	[PMUX_PINGRP_SDMMC1_DAT0_PY7] = "sdmmc1_dat0_py7",
	[PMUX_PINGRP_CLK2_OUT_PW5] = "clk2_out_pw5",
	[PMUX_PINGRP_CLK2_REQ_PCC5] = "clk2_req_pcc5",
	[PMUX_PINGRP_HDMI_INT_PN7] = "hdmi_int_pn7",
	[PMUX_PINGRP_DDC_SCL_PV4] = "ddc_scl_pv4",
	[PMUX_PINGRP_DDC_SDA_PV5] = "ddc_sda_pv5",
	[PMUX_PINGRP_UART2_RXD_PC3] = "uart2_rxd_pc3",
	[PMUX_PINGRP_UART2_TXD_PC2] = "uart2_txd_pc2",
	[PMUX_PINGRP_UART2_RTS_N_PJ6] = "uart2_rts_n_pj6",
	[PMUX_PINGRP_UART2_CTS_N_PJ5] = "uart2_cts_n_pj5",
	[PMUX_PINGRP_UART3_TXD_PW6] = "uart3_txd_pw6",
	[PMUX_PINGRP_UART3_RXD_PW7] = "uart3_rxd_pw7",
	[PMUX_PINGRP_UART3_CTS_N_PA1] = "uart3_cts_n_pa1",
	[PMUX_PINGRP_UART3_RTS_N_PC0] = "uart3_rts_n_pc0",
	[PMUX_PINGRP_PU0] = "pu0",
	[PMUX_PINGRP_PU1] = "pu1",
	[PMUX_PINGRP_PU2] = "pu2",
	[PMUX_PINGRP_PU3] = "pu3",
	[PMUX_PINGRP_PU4] = "pu4",
	[PMUX_PINGRP_PU5] = "pu5",
	[PMUX_PINGRP_PU6] = "pu6",
	[PMUX_PINGRP_GEN1_I2C_SDA_PC5] = "gen1_i2c_sda_pc5",
	[PMUX_PINGRP_GEN1_I2C_SCL_PC4] = "gen1_i2c_scl_pc4",
	[PMUX_PINGRP_DAP4_FS_PP4] = "dap4_fs_pp4",
	[PMUX_PINGRP_DAP4_DIN_PP5] = "dap4_din_pp5",
	[PMUX_PINGRP_DAP4_DOUT_PP6] = "dap4_dout_pp6",
	[PMUX_PINGRP_DAP4_SCLK_PP7] = "dap4_sclk_pp7",
	[PMUX_PINGRP_CLK3_OUT_PEE0] = "clk3_out_pee0",
	[PMUX_PINGRP_CLK3_REQ_PEE1] = "clk3_req_pee1",
	[PMUX_PINGRP_PC7] = "pc7",
	[PMUX_PINGRP_PI5] = "pi5",
	[PMUX_PINGRP_PI7] = "pi7",
	[PMUX_PINGRP_PK0] = "pk0",
	[PMUX_PINGRP_PK1] = "pk1",
	[PMUX_PINGRP_PJ0] = "pj0",
	[PMUX_PINGRP_PJ2] = "pj2",
	[PMUX_PINGRP_PK3] = "pk3",
	[PMUX_PINGRP_PK4] = "pk4",
	[PMUX_PINGRP_PK2] = "pk2",
	[PMUX_PINGRP_PI3] = "pi3",
	[PMUX_PINGRP_PI6] = "pi6",
	[PMUX_PINGRP_PG0] = "pg0",
	[PMUX_PINGRP_PG1] = "pg1",
	[PMUX_PINGRP_PG2] = "pg2",
	[PMUX_PINGRP_PG3] = "pg3",
	[PMUX_PINGRP_PG4] = "pg4",
	[PMUX_PINGRP_PG5] = "pg5",
	[PMUX_PINGRP_PG6] = "pg6",
	[PMUX_PINGRP_PG7] = "pg7",
	[PMUX_PINGRP_PH0] = "ph0",
	[PMUX_PINGRP_PH1] = "ph1",
	[PMUX_PINGRP_PH2] = "ph2",
	[PMUX_PINGRP_PH3] = "ph3",
	[PMUX_PINGRP_PH4] = "ph4",
	[PMUX_PINGRP_PH5] = "ph5",
	[PMUX_PINGRP_PH6] = "ph6",
	[PMUX_PINGRP_PH7] = "ph7",
	[PMUX_PINGRP_PJ7] = "pj7",
	[PMUX_PINGRP_PB0] = "pb0",
	[PMUX_PINGRP_PB1] = "pb1",
	[PMUX_PINGRP_PK7] = "pk7",
	[PMUX_PINGRP_PI0] = "pi0",
	[PMUX_PINGRP_PI1] = "pi1",
	[PMUX_PINGRP_PI2] = "pi2",
	[PMUX_PINGRP_PI4] = "pi4",
	[PMUX_PINGRP_GEN2_I2C_SCL_PT5] = "gen2_i2c_scl_pt5",
	[PMUX_PINGRP_GEN2_I2C_SDA_PT6] = "gen2_i2c_sda_pt6",
	[PMUX_PINGRP_SDMMC4_CLK_PCC4] = "sdmmc4_clk_pcc4",
	[PMUX_PINGRP_SDMMC4_CMD_PT7] = "sdmmc4_cmd_pt7",
	[PMUX_PINGRP_SDMMC4_DAT0_PAA0] = "sdmmc4_dat0_paa0",
	[PMUX_PINGRP_SDMMC4_DAT1_PAA1] = "sdmmc4_dat1_paa1",
	[PMUX_PINGRP_SDMMC4_DAT2_PAA2] = "sdmmc4_dat2_paa2",
	[PMUX_PINGRP_SDMMC4_DAT3_PAA3] = "sdmmc4_dat3_paa3",
	[PMUX_PINGRP_SDMMC4_DAT4_PAA4] = "sdmmc4_dat4_paa4",
	[PMUX_PINGRP_SDMMC4_DAT5_PAA5] = "sdmmc4_dat5_paa5",
	[PMUX_PINGRP_SDMMC4_DAT6_PAA6] = "sdmmc4_dat6_paa6",
	[PMUX_PINGRP_SDMMC4_DAT7_PAA7] = "sdmmc4_dat7_paa7",
	[PMUX_PINGRP_CAM_MCLK_PCC0] = "cam_mclk_pcc0",
	[PMUX_PINGRP_PCC1] = "pcc1",
	[PMUX_PINGRP_PBB0] = "pbb0",
	[PMUX_PINGRP_CAM_I2C_SCL_PBB1] = "cam_i2c_scl_pbb1",
	[PMUX_PINGRP_CAM_I2C_SDA_PBB2] = "cam_i2c_sda_pbb2",
	[PMUX_PINGRP_PBB3] = "pbb3",
	[PMUX_PINGRP_PBB4] = "pbb4",
	[PMUX_PINGRP_PBB5] = "pbb5",
	[PMUX_PINGRP_PBB6] = "pbb6",
	[PMUX_PINGRP_PBB7] = "pbb7",
	[PMUX_PINGRP_PCC2] = "pcc2",
	[PMUX_PINGRP_JTAG_RTCK] = "jtag_rtck",
	[PMUX_PINGRP_PWR_I2C_SCL_PZ6] = "pwr_i2c_scl_pz6",
	[PMUX_PINGRP_PWR_I2C_SDA_PZ7] = "pwr_i2c_sda_pz7",
	[PMUX_PINGRP_KB_ROW0_PR0] = "kb_row0_pr0",
	[PMUX_PINGRP_KB_ROW1_PR1] = "kb_row1_pr1",
	[PMUX_PINGRP_KB_ROW2_PR2] = "kb_row2_pr2",
	[PMUX_PINGRP_KB_ROW3_PR3] = "kb_row3_pr3",
	[PMUX_PINGRP_KB_ROW4_PR4] = "kb_row4_pr4",
	[PMUX_PINGRP_KB_ROW5_PR5] = "kb_row5_pr5",
	[PMUX_PINGRP_KB_ROW6_PR6] = "kb_row6_pr6",
	[PMUX_PINGRP_KB_ROW7_PR7] = "kb_row7_pr7",
	[PMUX_PINGRP_KB_ROW8_PS0] = "kb_row8_ps0",
	[PMUX_PINGRP_KB_ROW9_PS1] = "kb_row9_ps1",
	[PMUX_PINGRP_KB_ROW10_PS2] = "kb_row10_ps2",
	[PMUX_PINGRP_KB_ROW11_PS3] = "kb_row11_ps3",
	[PMUX_PINGRP_KB_ROW12_PS4] = "kb_row12_ps4",
	[PMUX_PINGRP_KB_ROW13_PS5] = "kb_row13_ps5",
	[PMUX_PINGRP_KB_ROW14_PS6] = "kb_row14_ps6",
	[PMUX_PINGRP_KB_ROW15_PS7] = "kb_row15_ps7",
	[PMUX_PINGRP_KB_COL0_PQ0] = "kb_col0_pq0",
	[PMUX_PINGRP_KB_COL1_PQ1] = "kb_col1_pq1",
	[PMUX_PINGRP_KB_COL2_PQ2] = "kb_col2_pq2",
	[PMUX_PINGRP_KB_COL3_PQ3] = "kb_col3_pq3",
	[PMUX_PINGRP_KB_COL4_PQ4] = "kb_col4_pq4",
	[PMUX_PINGRP_KB_COL5_PQ5] = "kb_col5_pq5",
	[PMUX_PINGRP_KB_COL6_PQ6] = "kb_col6_pq6",
	[PMUX_PINGRP_KB_COL7_PQ7] = "kb_col7_pq7",
	[PMUX_PINGRP_CLK_32K_OUT_PA0] = "clk_32k_out_pa0",
	[PMUX_PINGRP_CORE_PWR_REQ] = "core_pwr_req",
	[PMUX_PINGRP_CPU_PWR_REQ] = "cpu_pwr_req",
	[PMUX_PINGRP_PWR_INT_N] = "pwr_int_n",
	[PMUX_PINGRP_CLK_32K_IN] = "clk_32k_in",
	[PMUX_PINGRP_OWR] = "owr",
	[PMUX_PINGRP_DAP1_FS_PN0] = "dap1_fs_pn0",
	[PMUX_PINGRP_DAP1_DIN_PN1] = "dap1_din_pn1",
	[PMUX_PINGRP_DAP1_DOUT_PN2] = "dap1_dout_pn2",
	[PMUX_PINGRP_DAP1_SCLK_PN3] = "dap1_sclk_pn3",
	[PMUX_PINGRP_DAP_MCLK1_REQ_PEE2] = "dap_mclk1_req_pee2",
	[PMUX_PINGRP_DAP_MCLK1_PW4] = "dap_mclk1_pw4",
	[PMUX_PINGRP_SPDIF_IN_PK6] = "spdif_in_pk6",
	[PMUX_PINGRP_SPDIF_OUT_PK5] = "spdif_out_pk5",
	[PMUX_PINGRP_DAP2_FS_PA2] = "dap2_fs_pa2",
	[PMUX_PINGRP_DAP2_DIN_PA4] = "dap2_din_pa4",
	[PMUX_PINGRP_DAP2_DOUT_PA5] = "dap2_dout_pa5",
	[PMUX_PINGRP_DAP2_SCLK_PA3] = "dap2_sclk_pa3",
	[PMUX_PINGRP_DVFS_PWM_PX0] = "dvfs_pwm_px0",
	[PMUX_PINGRP_GPIO_X1_AUD_PX1] = "gpio_x1_aud_px1",
	[PMUX_PINGRP_GPIO_X3_AUD_PX3] = "gpio_x3_aud_px3",
	[PMUX_PINGRP_DVFS_CLK_PX2] = "dvfs_clk_px2",
	[PMUX_PINGRP_GPIO_X4_AUD_PX4] = "gpio_x4_aud_px4",
	[PMUX_PINGRP_GPIO_X5_AUD_PX5] = "gpio_x5_aud_px5",
	[PMUX_PINGRP_GPIO_X6_AUD_PX6] = "gpio_x6_aud_px6",
	[PMUX_PINGRP_GPIO_X7_AUD_PX7] = "gpio_x7_aud_px7",
	[PMUX_PINGRP_SDMMC3_CLK_PA6] = "sdmmc3_clk_pa6",
	[PMUX_PINGRP_SDMMC3_CMD_PA7] = "sdmmc3_cmd_pa7",
	[PMUX_PINGRP_SDMMC3_DAT0_PB7] = "sdmmc3_dat0_pb7",
	[PMUX_PINGRP_SDMMC3_DAT1_PB6] = "sdmmc3_dat1_pb6",
	[PMUX_PINGRP_SDMMC3_DAT2_PB5] = "sdmmc3_dat2_pb5",
	[PMUX_PINGRP_SDMMC3_DAT3_PB4] = "sdmmc3_dat3_pb4",
	[PMUX_PINGRP_PEX_L0_RST_N_PDD1] = "pex_l0_rst_n_pdd1",
	[PMUX_PINGRP_PEX_L0_CLKREQ_N_PDD2] = "pex_l0_clkreq_n_pdd2",
	[PMUX_PINGRP_PEX_WAKE_N_PDD3] = "pex_wake_n_pdd3",
	[PMUX_PINGRP_PEX_L1_RST_N_PDD5] = "pex_l1_rst_n_pdd5",
	[PMUX_PINGRP_PEX_L1_CLKREQ_N_PDD6] = "pex_l1_clkreq_n_pdd6",
	[PMUX_PINGRP_HDMI_CEC_PEE3] = "hdmi_cec_pee3",
	[PMUX_PINGRP_SDMMC1_WP_N_PV3] = "sdmmc1_wp_n_pv3",
	[PMUX_PINGRP_SDMMC3_CD_N_PV2] = "sdmmc3_cd_n_pv2",
	[PMUX_PINGRP_GPIO_W2_AUD_PW2] = "gpio_w2_aud_pw2",
	[PMUX_PINGRP_GPIO_W3_AUD_PW3] = "gpio_w3_aud_pw3",
	[PMUX_PINGRP_USB_VBUS_EN0_PN4] = "usb_vbus_en0_pn4",
	[PMUX_PINGRP_USB_VBUS_EN1_PN5] = "usb_vbus_en1_pn5",
	[PMUX_PINGRP_SDMMC3_CLK_LB_IN_PEE5] = "sdmmc3_clk_lb_in_pee5",
	[PMUX_PINGRP_SDMMC3_CLK_LB_OUT_PEE4] = "sdmmc3_clk_lb_out_pee4",
	[PMUX_PINGRP_GMI_CLK_LB] = "gmi_clk_lb",
	[PMUX_PINGRP_RESET_OUT_N] = "reset_out_n",
	[PMUX_PINGRP_KB_ROW16_PT0] = "kb_row16_pt0",
	[PMUX_PINGRP_KB_ROW17_PT1] = "kb_row17_pt1",
	[PMUX_PINGRP_USB_VBUS_EN2_PFF1] = "usb_vbus_en2_pff1",
	[PMUX_PINGRP_PFF2] = "pff2",
	[PMUX_PINGRP_DP_HPD_PFF0] = "dp_hpd_pff0",
};

static const char * const tegra_pinctrl_to_drvgrp[] = {
	[PMUX_DRVGRP_AO1] = "ao1",
	[PMUX_DRVGRP_AO2] = "ao2",
	[PMUX_DRVGRP_AT1] = "at1",
	[PMUX_DRVGRP_AT2] = "at2",
	[PMUX_DRVGRP_AT3] = "at3",
	[PMUX_DRVGRP_AT4] = "at4",
	[PMUX_DRVGRP_AT5] = "at5",
	[PMUX_DRVGRP_CDEV1] = "cdev1",
	[PMUX_DRVGRP_CDEV2] = "cdev2",
	[PMUX_DRVGRP_DAP1] = "dap1",
	[PMUX_DRVGRP_DAP2] = "dap2",
	[PMUX_DRVGRP_DAP3] = "dap3",
	[PMUX_DRVGRP_DAP4] = "dap4",
	[PMUX_DRVGRP_DBG] = "dbg",
	[PMUX_DRVGRP_SDIO3] = "sdio3",
	[PMUX_DRVGRP_SPI] = "spi",
	[PMUX_DRVGRP_UAA] = "uaa",
	[PMUX_DRVGRP_UAB] = "uab",
	[PMUX_DRVGRP_UART2] = "uart2",
	[PMUX_DRVGRP_UART3] = "uart3",
	[PMUX_DRVGRP_SDIO1] = "sdio1",
	[PMUX_DRVGRP_DDC] = "ddc",
	[PMUX_DRVGRP_GMA] = "gma",
	[PMUX_DRVGRP_GME] = "gme",
	[PMUX_DRVGRP_GMF] = "gmf",
	[PMUX_DRVGRP_GMG] = "gmg",
	[PMUX_DRVGRP_GMH] = "gmh",
	[PMUX_DRVGRP_OWR] = "owr",
	[PMUX_DRVGRP_UDA] = "uda",
	[PMUX_DRVGRP_GPV] = "gpv",
	[PMUX_DRVGRP_DEV3] = "dev3",
	[PMUX_DRVGRP_CEC] = "cec",
	[PMUX_DRVGRP_AT6] = "at6",
	[PMUX_DRVGRP_DAP5] = "dap5",
	[PMUX_DRVGRP_USB_VBUS_EN] = "usb_vbus_en",
	[PMUX_DRVGRP_AO3] = "ao3",
	[PMUX_DRVGRP_AO0] = "ao0",
	[PMUX_DRVGRP_HV0] = "hv0",
	[PMUX_DRVGRP_SDIO4] = "sdio4",
	[PMUX_DRVGRP_AO4] = "ao4",
};

static const char * const tegra_pinctrl_to_func[] = {
	[PMUX_FUNC_DEFAULT] = "default",
	[PMUX_FUNC_BLINK] = "blink",
	[PMUX_FUNC_CCLA] = "ccla",
	[PMUX_FUNC_CEC] = "cec",
	[PMUX_FUNC_CLDVFS] = "cldvfs",
	[PMUX_FUNC_CLK] = "clk",
	[PMUX_FUNC_CLK12] = "clk12",
	[PMUX_FUNC_CPU] = "cpu",
	[PMUX_FUNC_CSI] = "csi",
	[PMUX_FUNC_DAP] = "dap",
	[PMUX_FUNC_DAP1] = "dap1",
	[PMUX_FUNC_DAP2] = "dap2",
	[PMUX_FUNC_DEV3] = "dev3",
	[PMUX_FUNC_DISPLAYA] = "displaya",
	[PMUX_FUNC_DISPLAYA_ALT] = "displaya_alt",
	[PMUX_FUNC_DISPLAYB] = "displayb",
	[PMUX_FUNC_DP] = "dp",
	[PMUX_FUNC_DSI_B] = "dsi_b",
	[PMUX_FUNC_DTV] = "dtv",
	[PMUX_FUNC_EXTPERIPH1] = "extperiph1",
	[PMUX_FUNC_EXTPERIPH2] = "extperiph2",
	[PMUX_FUNC_EXTPERIPH3] = "extperiph3",
	[PMUX_FUNC_GMI] = "gmi",
	[PMUX_FUNC_GMI_ALT] = "gmi_alt",
	[PMUX_FUNC_HDA] = "hda",
	[PMUX_FUNC_HSI] = "hsi",
	[PMUX_FUNC_I2C1] = "i2c1",
	[PMUX_FUNC_I2C2] = "i2c2",
	[PMUX_FUNC_I2C3] = "i2c3",
	[PMUX_FUNC_I2C4] = "i2c4",
	[PMUX_FUNC_I2CPWR] = "i2cpwr",
	[PMUX_FUNC_I2S0] = "i2s0",
	[PMUX_FUNC_I2S1] = "i2s1",
	[PMUX_FUNC_I2S2] = "i2s2",
	[PMUX_FUNC_I2S3] = "i2s3",
	[PMUX_FUNC_I2S4] = "i2s4",
	[PMUX_FUNC_IRDA] = "irda",
	[PMUX_FUNC_KBC] = "kbc",
	[PMUX_FUNC_OWR] = "owr",
	[PMUX_FUNC_PE] = "pe",
	[PMUX_FUNC_PE0] = "pe0",
	[PMUX_FUNC_PE1] = "pe1",
	[PMUX_FUNC_PMI] = "pmi",
	[PMUX_FUNC_PWM0] = "pwm0",
	[PMUX_FUNC_PWM1] = "pwm1",
	[PMUX_FUNC_PWM2] = "pwm2",
	[PMUX_FUNC_PWM3] = "pwm3",
	[PMUX_FUNC_PWRON] = "pwron",
	[PMUX_FUNC_RESET_OUT_N] = "reset_out_n",
	[PMUX_FUNC_RTCK] = "rtck",
	[PMUX_FUNC_SATA] = "sata",
	[PMUX_FUNC_SDMMC1] = "sdmmc1",
	[PMUX_FUNC_SDMMC2] = "sdmmc2",
	[PMUX_FUNC_SDMMC3] = "sdmmc3",
	[PMUX_FUNC_SDMMC4] = "sdmmc4",
	[PMUX_FUNC_SOC] = "soc",
	[PMUX_FUNC_SPDIF] = "spdif",
	[PMUX_FUNC_SPI1] = "spi1",
	[PMUX_FUNC_SPI2] = "spi2",
	[PMUX_FUNC_SPI3] = "spi3",
	[PMUX_FUNC_SPI4] = "spi4",
	[PMUX_FUNC_SPI5] = "spi5",
	[PMUX_FUNC_SPI6] = "spi6",
	[PMUX_FUNC_SYS] = "sys",
	[PMUX_FUNC_TMDS] = "tmds",
	[PMUX_FUNC_TRACE] = "trace",
	[PMUX_FUNC_UARTA] = "uarta",
	[PMUX_FUNC_UARTB] = "uartb",
	[PMUX_FUNC_UARTC] = "uartc",
	[PMUX_FUNC_UARTD] = "uartd",
	[PMUX_FUNC_ULPI] = "ulpi",
	[PMUX_FUNC_USB] = "usb",
	[PMUX_FUNC_VGP1] = "vgp1",
	[PMUX_FUNC_VGP2] = "vgp2",
	[PMUX_FUNC_VGP3] = "vgp3",
	[PMUX_FUNC_VGP4] = "vgp4",
	[PMUX_FUNC_VGP5] = "vgp5",
	[PMUX_FUNC_VGP6] = "vgp6",
	[PMUX_FUNC_VI] = "vi",
	[PMUX_FUNC_VI_ALT1] = "vi_alt1",
	[PMUX_FUNC_VI_ALT3] = "vi_alt3",
	[PMUX_FUNC_VIMCLK2] = "vimclk2",
	[PMUX_FUNC_VIMCLK2_ALT] = "vimclk2_alt",
	[PMUX_FUNC_RSVD1] = "rsvd1",
	[PMUX_FUNC_RSVD2] = "rsvd2",
	[PMUX_FUNC_RSVD3] = "rsvd3",
	[PMUX_FUNC_RSVD4] = "rsvd4",
};

#define TEGRA_PMX_SOC_DRV_GROUP_BASE_REG 0x868
#define TEGRA_PMX_SOC_MIPIPADCTRL_BASE_REG 0x820
#define TEGRA_PMX_SOC_HAS_IO_CLAMPING
#define TEGRA_PMX_SOC_HAS_DRVGRPS
#define TEGRA_PMX_SOC_HAS_MIPI_PAD_CTRL_GRPS
#define TEGRA_PMX_GRPS_HAVE_LPMD
#define TEGRA_PMX_GRPS_HAVE_SCHMT
#define TEGRA_PMX_GRPS_HAVE_HSM
#define TEGRA_PMX_PINS_HAVE_E_INPUT
#define TEGRA_PMX_PINS_HAVE_LOCK
#define TEGRA_PMX_PINS_HAVE_OD
#define TEGRA_PMX_PINS_HAVE_IO_RESET
#define TEGRA_PMX_PINS_HAVE_RCV_SEL
#include <asm/arch-tegra/pinmux.h>

#endif /* _TEGRA124_PINMUX_H_ */
