!!****m* ABINIT/defs_scfcvargs
!! NAME
!! defs_scfcvargs
!!
!! FUNCTION
!! This module contains definitions of high-level structured datatypes for the
!! ABINIT package, related to the routine scfcv.F90.
!!
!! If you are sure a new high-level structured datatype is needed,
!! write it here, and DOCUMENT it properly (not all datastructure here are
!! well documented, it is a shame ...).
!! Do not forget : you will likely be the major winner if you document
!! properly.
!! Proper documentation of a structured datatype means :
!!  (1) Mention it in the list just below
!!  (2) Describe it in the NOTES section
!!  (3) Put it in alphabetical order in the the main section of this module
!!  (4) Document each of its records, except if they are described elsewhere
!!      (this exception is typically the case of the dataset associated with
!!      input variables, for which there is a help file)
!!  (5) Declare variables on separated lines in order to reduce the occurence 
!!      of bzr conflicts.
!!
!! List of datatypes :
!! * scfcvargs   : a container for all the arguments except rprimd and xred
!!                 of the scfcv routine
!!
!! COPYRIGHT
!! Copyright (C) 2001-2014 ABINIT group (XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


module defs_scfcvargs

 use defs_basis
 use defs_abitypes
 use defs_scftypes
 use m_wffile
 use m_profiling

 use m_electronpositron, only : electronpositron_type
 use m_efield,           only : efield_type
 use m_paw_dmft,         only : paw_dmft_type


 implicit none

!Structures
!!***

!!****t* defs_scftypes/ab_scfcvargs
!! NAME
!! ab_scfcvargs
!!
!! FUNCTION
!! This datatype has the purpouse of store all the
!! arguments needed by the routine scfcv 
!!
!! NOTES
!!
!!
!! SOURCE

type ab_scfcvargs

!scalars
 type(ab_scfcv_args_in),pointer :: ab_scfcv_in => null()
 type(ab_scfcv_args_inout),pointer :: ab_scfcv_inout => null()
 type(dataset_type),pointer :: dtset => null()
 type(electronpositron_type),pointer :: electronpositron => null()
 type(paw_dmft_type),pointer :: paw_dmft => null()
 type(wffile_type),pointer :: wffnew => null()
 type(wffile_type),pointer :: wffnow => null()
! TODO: check if we need to add efield object here
! type(efield_type), pointer :: dtefield
!arrays

end type ab_scfcvargs

end module defs_scfcvargs
!!***
