/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:24:57 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Canvas;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureChangeEvent;
import uk.ac.sanger.artemis.FeatureSegment;
import uk.ac.sanger.artemis.FeatureSegmentVector;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SelectionChangeListener;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Selection_ESTest extends Selection_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      DataFlavor dataFlavor0 = DataFlavor.stringFlavor;
      boolean boolean0 = selection0.isDataFlavorSupported(dataFlavor0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      // Undeclared exception!
      try { 
        selection0.set((FeatureVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Selection", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      // Undeclared exception!
      try { 
        selection0.removeSegmentsOf((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Selection", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("org.biojava.utils.AssertionFailure");
      Selection selection0 = new Selection(clipboard0);
      // Undeclared exception!
      try { 
        selection0.isDataFlavorSupported((DataFlavor) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Selection", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      // Undeclared exception!
      try { 
        selection0.getTransferData((DataFlavor) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Selection", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("DG/14.>%x\"Lt+");
      Selection selection0 = new Selection(clipboard0);
      // Undeclared exception!
      try { 
        selection0.entryChanged((EntryChangeEvent) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Selection", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      // Undeclared exception!
      try { 
        selection0.contains((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FeatureVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("5'], ,");
      Selection selection0 = new Selection(clipboard0);
      // Undeclared exception!
      try { 
        selection0.add((FeatureVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Selection", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      // Undeclared exception!
      try { 
        selection0.add((FeatureSegment) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - adding a null object
         //
         verifyException("uk.ac.sanger.artemis.util.FastVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      // Undeclared exception!
      try { 
        selection0.add((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FeatureVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("_oqP&Z! _|");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getAllFeatures();
      FeatureVector featureVector1 = selection0.getAllFeatures();
      assertSame(featureVector1, featureVector0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      FeatureSegmentVector featureSegmentVector0 = selection0.getAllSegments();
      assertNotNull(featureSegmentVector0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      Marker marker0 = selection0.getHighestBaseOfSelection();
      assertNull(marker0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("org.biojava.utils.AssertionFailure");
      Selection selection0 = new Selection(clipboard0);
      Marker marker0 = selection0.getLowestBaseOfSelection();
      assertNull(marker0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      boolean boolean0 = selection0.isEmpty();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("5'], ,");
      Selection selection0 = new Selection(clipboard0);
      String string0 = selection0.getSelectionText();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      MarkerRange markerRange0 = selection0.getMarkerRange();
      assertNull(markerRange0);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      FeatureSegmentVector featureSegmentVector0 = selection0.getSelectedSegments();
      assertNotNull(featureSegmentVector0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Selection selection0 = new Selection((Clipboard) null);
      selection0.getAllFeatures();
      String string0 = selection0.getSelectedBases();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      Marker marker0 = selection0.getEndBaseOfSelection();
      assertNull(marker0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      Range range0 = selection0.getSelectionRange();
      assertNull(range0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("bKR[V/?,U'z");
      Selection selection0 = new Selection(clipboard0);
      boolean boolean0 = selection0.contains((FeatureSegment) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      selection0.remove((FeatureSegment) null);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("Selection.fireAction () - unknown event");
      Selection selection0 = new Selection(clipboard0);
      selection0.remove((Feature) null);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      selection0.clear();
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      selection0.setMarkerRange((MarkerRange) null);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      Bases bases0 = new Bases(emblStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("");
      FeatureVector featureVector0 = entry0.checkForMissingQualifiers();
      selection0.set(featureVector0);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard((String) null);
      Selection selection0 = new Selection(clipboard0);
      Bases bases0 = new Bases((Sequence) null);
      Entry entry0 = Entry.newEntry(bases0);
      EntryChangeEvent entryChangeEvent0 = new EntryChangeEvent(entry0, (Feature) null, false, 109);
      selection0.entryChanged(entryChangeEvent0);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("2HSvt33 -]#");
      Selection selection0 = new Selection(clipboard0);
      // Undeclared exception!
      try { 
        selection0.featureChanged((FeatureChangeEvent) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Selection", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("5'], ,");
      Selection selection0 = new Selection(clipboard0);
      DataFlavor dataFlavor0 = DataFlavor.stringFlavor;
      Object object0 = selection0.getTransferData(dataFlavor0);
      assertEquals("", object0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("_oqP&Z! _|");
      Selection selection0 = new Selection(clipboard0);
      Class<Canvas> class0 = Canvas.class;
      DataFlavor dataFlavor0 = new DataFlavor(class0, "");
      try { 
        selection0.getTransferData(dataFlavor0);
        fail("Expecting exception: UnsupportedFlavorException");
      
      } catch(UnsupportedFlavorException e) {
         //
         // 
         //
         verifyException("uk.ac.sanger.artemis.Selection", e);
      }
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard((String) null);
      Selection selection0 = new Selection(clipboard0);
      // Undeclared exception!
      try { 
        selection0.set((FeatureSegment) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - adding a null object
         //
         verifyException("uk.ac.sanger.artemis.util.FastVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      selection0.removeSelectionChangeListener((SelectionChangeListener) null);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      Selection selection0 = new Selection((Clipboard) null);
      RangeVector rangeVector0 = selection0.getSelectionRanges();
      assertEquals("[]", rangeVector0.toString());
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      selection0.addSelectionChangeListener((SelectionChangeListener) null);
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      // Undeclared exception!
      try { 
        selection0.set((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FeatureVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("m*~U#=v>J+C");
      Selection selection0 = new Selection(clipboard0);
      selection0.lostOwnership(clipboard0, (Transferable) null);
      assertEquals("m*~U#=v>J+C", clipboard0.getName());
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      DataFlavor dataFlavor0 = DataFlavor.selectionHtmlFlavor;
      boolean boolean0 = selection0.isDataFlavorSupported(dataFlavor0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      DataFlavor[] dataFlavorArray0 = selection0.getTransferDataFlavors();
      assertNotNull(dataFlavorArray0);
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      Selection selection0 = new Selection((Clipboard) null);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      selection0.add(featureVector0);
  }
}
