subroutine nmfeti(numedd, ifm, lfeti, nivmpi, lfetip)
!
! ======================================================================
! COPYRIGHT (C) 1991 - 2012  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!   1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
! person_in_charge: mickael.abbas at edf.fr
!
    implicit none
#include "jeveux.h"
#include "asterfort/fetmpi.h"
#include "asterfort/jedema.h"
#include "asterfort/jemarq.h"
#include "asterfort/jeveuo.h"
    logical :: lfeti, lfetip
    integer :: nivmpi
    integer :: ifm
    character(len=24) :: numedd
!
! ----------------------------------------------------------------------
!
! ROUTINE MECA_NON_LINE (UTILITAIRE)
!
! PREPARATION FETI
!
! ----------------------------------------------------------------------
!
!
! IN  IFM    : NUMERO DU FICHIER LOGIQUE MESSAGE
! IN  NUMEDD : NUME_DDL
! OUT NIVMPI : NIVEAU IMPRESSION MPI
! OUT NBPROC : NOMBRE DE PROCESSEURS
! OUT LFETI  : .TRUE. SI SOLVEUR FETI
! OUT LFETIP : .TRUE. SI SOLVEUR FETI PARALLELE
!
!
!
!
    integer :: jrefn, iinf, ibid, nbproc
    real(kind=8) :: r8bid
    character(len=24) :: kmet, infofe, k24bid
!
! ----------------------------------------------------------------------
!
    call jemarq()
!
    nbproc = 1
    lfeti = .false.
    lfetip = .false.
!
    call jeveuo(numedd(1:14)//'.NUME.REFN', 'L', jrefn)
    kmet = zk24(jrefn+2)
    if (kmet(1:4) .eq. 'FETI') then
        lfeti = .true.
        call jeveuo('&FETI.FINF', 'L', iinf)
        infofe = zk24(iinf)
        if (infofe(10:10) .eq. 'T') then
            nivmpi=2
        else
            nivmpi=1
        endif
        call fetmpi(3, ibid, ifm, nivmpi, ibid,&
                    nbproc, k24bid, k24bid, k24bid, r8bid)
    else
        lfeti = .false.
    endif
!
    if (lfeti) then
        if (nbproc .gt. 1) then
            lfetip = .true.
        endif
    endif
!
    call jedema()
end subroutine
