/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "PythonExtensionTabPresenter.h"

#include "ListFieldEditor.h"

// -------------------- constructor --------------------
PythonExtensionTabPresenter::PythonExtensionTabPresenter(CamiTKExtensionModelPresenter* presenter, VariantDataModel& dataModel, QWidget* parent) : ExtensionTabPresenter(presenter, dataModel, parent) {
    //-- python specific field
    ListFieldEditor* requirementFieldEditor = new ListFieldEditor(presenter, dataModel["requirements"], "requirements", "<p>Requirements is the list of python package that are required by the python action script(s). A python virtual environment is automatically created and managed for this extension.</p><p>The venv is managed in the <tt>.venv</tt> subdirectory. CamiTK checks it exists at launch time and create it if it does not (feel free to remove the <tt>.venv</tt> subdirectory at any time it if you want to start from scratch).</p><p>You <b>must not manage the virtual environment manually</b>. If your script requires a new python module or package, just update the requirements field here. Each requirement here will be installed automatically in the virtual environment when the application restarts.</p><p>The syntax for each requirement must follow the <a href='https://pip.pypa.io/en/stable/reference/requirements-file-format/'>pip requirements file format syntax</a>.</p><p>Press <tt>Insert</tt> or <tt>+</tt> to insert new requirements, <tt>Delete</tt> to remove the current requirement, and click on a requirement to edit its value.");
    requirementFieldEditor->appendRowTo(extensionTabLayout);
}
