/***************************************************************************
 *                                  _   _ ____  _
 *  Project                     ___| | | |  _ \| |
 *                             / __| | | | |_) | |
 *                            | (__| |_| |  _ <| |___
 *                             \___|\___/|_| \_\_____|
 *
 * Copyright (C) 1998 - 2004, Daniel Stenberg, <daniel@haxx.se>, et al.
 *
 * This software is licensed as described in the file COPYING, which
 * you should have received as part of this distribution. The terms
 * are also available at http://curl.haxx.se/docs/copyright.html.
 *
 * You may opt to use, copy, modify, merge, publish, distribute and/or sell
 * copies of the Software, and permit persons to whom the Software is
 * furnished to do so, under the terms of the COPYING file.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 * $Id: amigaos.c,v 1.3 2004/10/06 07:50:18 bagder Exp $
 ***************************************************************************/

#include "amigaos.h"
#include <stdio.h> /* for stderr */

struct Library *SocketBase = NULL;

void amiga_cleanup()
{
  if(SocketBase)
    CloseLibrary(SocketBase);

  SocketBase = NULL;
}

BOOL amiga_init()
{
  if(!SocketBase)
    SocketBase = OpenLibrary("bsdsocket.library", 4);

  if(!SocketBase) {
    fprintf(stderr, "No TCP/IP Stack running!\n\a");
    return FALSE;
  }

  atexit(amiga_cleanup);
  return TRUE;
}
