Imports System
Imports System.Configuration
Imports System.Web
Imports System.Reflection
Imports Db4objects.Db4o
Imports Db4objects.Db4o.Config

Namespace Db4objects.Db4odoc.Web.Data

    Public Class Db4oHttpModule
        Implements IHttpModule
        Friend Shared ReadOnly KEY_DB4O_FILE_NAME As String = "db4oFileName"
        Friend Shared ReadOnly KEY_DB4O_CLIENT As String = "db4oClient"
        Private Shared objectServer As IObjectServer = Nothing

        Public Sub Init(ByVal application As HttpApplication) Implements IHttpModule.Init
            ConfigureAlias()
            AddHandler application.EndRequest, AddressOf Application_EndRequest
        End Sub
        ' end Init

        Public Sub ConfigureAlias()
            Dim asm As Assembly = Assembly.GetExecutingAssembly()
            Dim asmName = "Db4objects.Db4odoc.Web.Data.*, " + asm.GetName().ToString().Substring(0, asm.GetName().ToString().LastIndexOf("Version") - 2)
            Db4oFactory.Configure().AddAlias(New WildcardAlias("Db4objects.Db4odoc.Web.Data.*, WebSite", asmName))
        End Sub
        ' end ConfigureAlias

        Public Shared ReadOnly Property Client() As IObjectContainer
            Get
                Dim context As HttpContext = HttpContext.Current
                Dim objectClient As IObjectContainer = TryCast(context.Items(KEY_DB4O_CLIENT), IObjectContainer)
                If objectClient Is Nothing Then
                    objectClient = Server.OpenClient
                    context.Items(KEY_DB4O_CLIENT) = objectClient
                End If
                Return objectClient
            End Get
        End Property
        ' end Client

        Private Shared ReadOnly Property Server() As IObjectServer
            Get
                Dim context As HttpContext = HttpContext.Current
                If objectServer Is Nothing Then
                    Dim yapFilePath As String = context.Server.MapPath(ConfigurationManager.AppSettings(KEY_DB4O_FILE_NAME))
                    objectServer = Db4oFactory.OpenServer(yapFilePath, 0)
                End If
                Return objectServer
            End Get
        End Property
        ' end Server

        Public Shared ReadOnly Property HashCodes() As String
            Get
                Return "Server: " + DirectCast(Server, Object).GetHashCode().ToString + " Client: " + DirectCast(Client, Object).GetHashCode().ToString()
            End Get
        End Property
        ' end HashCodes

        Private Sub Application_EndRequest(ByVal sender As Object, ByVal e As EventArgs)
            Dim application As HttpApplication = CType(sender, HttpApplication)
            Dim context As HttpContext = application.Context
            Dim objectClient As IObjectContainer = TryCast(context.Items(KEY_DB4O_CLIENT), IObjectContainer)
            If Not (objectClient Is Nothing) Then
                objectClient.Close()
            End If
            objectClient = Nothing
            context.Items(KEY_DB4O_CLIENT) = Nothing
        End Sub
        ' end Application_EndRequest

        Public Sub Dispose() Implements IHttpModule.Dispose
            If Not (objectServer Is Nothing) Then
                objectServer.Close()
            End If
            objectServer = Nothing
        End Sub
        'end Dispose

    End Class
End Namespace