/**
 * \file
 *
 * \brief Allows one to list all available backends
 *
 * \copyright BSD License (see doc/COPYING or http://www.libelektra.org)
 *
 */

#ifndef TOOLS_BACKENDS_HPP
#define TOOLS_BACKENDS_HPP

#include <vector>
#include <string>

#include <keyset.hpp>
#include <toolexcept.hpp>

namespace kdb
{

namespace tools
{

/**
 * @brief Info about a backend
 */
struct BackendInfo
{
	std::string name;       ///< escaped mountpoint name (except for old mountpoints)
	std::string mountpoint; ///< where the backend is mounted
	std::string path;       ///< the configuration file path to this backend
};

/**
 * @brief Allows one to list backends
 */
class Backends
{
public:
	typedef std::vector<BackendInfo> BackendInfoVector;

	static BackendInfoVector getBackendInfo(KeySet mountConf);

	static BackendInfo findBackend(std::string const & backend, KeySet mountConf, bool verbose = false);

	static bool umount(std::string const & backend, KeySet & mountConf);

	static std::string getBasePath(std::string name);

	static const char * mountpointsPath;
};

}

}

#endif
