/* $Id: CaseStat.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CASE_STAT_HPP_INCLUDED
#define __CASE_STAT_HPP_INCLUDED

#include "frontend/ast/SeqStat.hpp"
#include "frontend/ast/Expression.hpp"
#include "frontend/ast/CaseAlternative.hpp"

namespace ast {

/** a VHDL case statement. */
class CaseStat : public SeqStat {
public:

	//! c'tor
	/** @param ref reference Expression.
          * @param choices List of CaseAlternative nodes.
	  * @param loc Location of the CaseStat.
          */
	CaseStat(
		Expression* ref, 
		std::list<CaseAlternative*>* choices,
		Location loc
		) : 	SeqStat(loc),
			select(ref),
			alternatives(choices) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << "case";
	}

	/** select value */
	Expression* select;
	
	/** list of CaseAlternative nodes */
	std::list<CaseAlternative*>* alternatives;

protected:
	/** Destructor */
	virtual ~CaseStat() {
		util::MiscUtil::terminate(select);
		util::MiscUtil::lterminate(alternatives);
	}
};

}; /* namespace ast */

#endif /* __CASE_STAT_HPP_INCLUDED */
