/* $Id: AttributableDeclaration.hpp 3886 2008-11-18 15:54:19Z potyra $
 *
 * AttributableDeclaration: base class for symbol declarations, that can have
 * attributes.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/AttributableDeclaration.hpp"

namespace ast {

AttributeSpecification *
AttributableDeclaration::hasAttr(std::string attrName) const
{
	std::map<std::string, AttributeSpecification*>::const_iterator i =
		this->attributes.find(attrName);

	if (i == attributes.end()) {
		return NULL;
	}

	return i->second;
}

}; /* namespace ast */
