#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("enables or disables the announcement of attributes")

    def run(self):
        self.env["runtime"]["SettingsManager"].set_setting(
            "general",
            "hasattributes",
            str(
                not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
                    "general", "hasattributes"
                )
            ),
        )
        if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "general", "hasattributes"
        ):
            self.env["runtime"]["OutputManager"].present_text(
                _("announcement of attributes enabled"),
                sound_icon="",
                interrupt=True,
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                _("announcement of attributes disabled"),
                sound_icon="",
                interrupt=True,
            )

    def set_callback(self, callback):
        pass
