/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.Assert;
import org.springframework.validation.AbstractPropertyBindingResult;

public class DirectFieldBindingResult
extends AbstractPropertyBindingResult {
    private final Object target;
    private transient ConfigurablePropertyAccessor directFieldAccessor;

    public DirectFieldBindingResult(Object target, String objectName) {
        super(objectName);
        Assert.notNull(target, "Target bean must not be null");
        this.target = target;
    }

    public final Object getTarget() {
        return this.target;
    }

    public final ConfigurablePropertyAccessor getPropertyAccessor() {
        if (this.directFieldAccessor == null) {
            this.directFieldAccessor = this.createDirectFieldAccessor();
            this.directFieldAccessor.setExtractOldValueForEditor(true);
        }
        return this.directFieldAccessor;
    }

    protected ConfigurablePropertyAccessor createDirectFieldAccessor() {
        return PropertyAccessorFactory.forDirectFieldAccess(this.getTarget());
    }
}

