/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGDSVariablesIF;
import ucar.grib.GribNumbers;

public class Grib1GDSVariables
implements GribGDSVariablesIF {
    private static Logger log = LoggerFactory.getLogger(Grib1GDSVariables.class);
    private final byte[] input;
    private final int length;
    private final int gdtn;
    private final int gdsKey;

    public Grib1GDSVariables(byte[] input) throws IOException {
        this.input = input;
        this.length = GribNumbers.int3(this.getInt(0), this.getInt(1), this.getInt(2));
        this.gdtn = this.getInt(5);
        double checkSum = this.gdtn;
        checkSum = 7.0 * checkSum + (double)this.get80La1();
        checkSum = 7.0 * checkSum + (double)this.get80Lo1();
        this.gdsKey = Double.toString(checkSum).hashCode();
    }

    public byte[] getGDSBytes() {
        return this.input;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getSection() {
        return 2;
    }

    public final int getNV() {
        return this.getInt(3);
    }

    public final int getPVorPL() {
        return this.getInt(4);
    }

    public final boolean isThin() {
        return this.getPVorPL() != 255 && (this.getNV() == 0 || this.getNV() == 255);
    }

    public final boolean hasVerticalPressureLevels() {
        return this.getPVorPL() != 255 && this.getNV() != 0 && this.getNV() != 255;
    }

    public final int getGdtn() {
        return this.gdtn;
    }

    public final int getNx() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 90: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: {
                int nx = GribNumbers.int2(this.getInt(6), this.getInt(7));
                if (nx == -1 || nx == -9999) {
                    if (this.getPVorPL() != 255 && (this.getNV() == 0 || this.getNV() == 255)) {
                        return this.calculateNx();
                    }
                    return 1;
                }
                return nx;
            }
        }
        return -9999;
    }

    public final int getNy() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 90: 
            case 202: 
            case 204: 
            case 205: {
                int ny = GribNumbers.int2(this.getInt(8), this.getInt(9));
                if (ny == -1 || ny == -9999) {
                    return 1;
                }
                return ny;
            }
            case 201: 
            case 203: {
                return 1;
            }
        }
        return -9999;
    }

    public final float getLap() {
        switch (this.gdtn) {
            case 90: {
                return GribNumbers.int3(this.getInt(10), this.getInt(11), this.getInt(12));
            }
        }
        return -9999.0f;
    }

    public final float getLop() {
        switch (this.gdtn) {
            case 90: {
                return GribNumbers.int3(this.getInt(13), this.getInt(14), this.getInt(15));
            }
        }
        return -9999.0f;
    }

    public final int getGridCenter() {
        switch (this.gdtn) {
            case 204: {
                return GribNumbers.int3(this.getInt(10), this.getInt(11), this.getInt(12));
            }
        }
        return -9999;
    }

    public final float getLa1() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                return (float)GribNumbers.int3(this.getInt(10), this.getInt(11), this.getInt(12)) / 1000.0f;
            }
        }
        return -9999.0f;
    }

    public final int getUnscaledLa1() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                return GribNumbers.int3(this.getInt(10), this.getInt(11), this.getInt(12));
            }
        }
        return -9999;
    }

    public final float get80La1() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                return (float)GribNumbers.int3(this.getInt(10), this.getInt(11), this.getInt(12)) * 0.001f;
            }
        }
        return -9999.0f;
    }

    public final float getLo1() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                return (float)GribNumbers.int3(this.getInt(13), this.getInt(14), this.getInt(15)) / 1000.0f;
            }
        }
        return -9999.0f;
    }

    public final int getUnscaledLo1() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                return GribNumbers.int3(this.getInt(13), this.getInt(14), this.getInt(15));
            }
        }
        return -9999;
    }

    public final float get80Lo1() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                return (float)GribNumbers.int3(this.getInt(13), this.getInt(14), this.getInt(15)) * 0.001f;
            }
        }
        return -9999.0f;
    }

    public final int getResolution() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 90: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: {
                return this.getInt(16);
            }
        }
        return -9999;
    }

    public final float getLoV() {
        switch (this.gdtn) {
            case 3: 
            case 5: 
            case 13: {
                return (float)GribNumbers.int3(this.getInt(17), this.getInt(18), this.getInt(19)) / 1000.0f;
            }
        }
        return -9999.0f;
    }

    public final float getLa2() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                return (float)GribNumbers.int3(this.getInt(17), this.getInt(18), this.getInt(19)) / 1000.0f;
            }
        }
        return -9999.0f;
    }

    public final float getLo2() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                return (float)GribNumbers.int3(this.getInt(20), this.getInt(21), this.getInt(22)) / 1000.0f;
            }
        }
        return -9999.0f;
    }

    public final float getDx() {
        switch (this.gdtn) {
            case 0: 
            case 4: 
            case 10: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                int dx = GribNumbers.int2(this.getInt(23), this.getInt(24));
                if (dx == -1 || dx == -9999) {
                    return this.calculateDx();
                }
                return (float)dx / 1000.0f;
            }
            case 90: {
                int dx = GribNumbers.int3(this.getInt(17), this.getInt(18), this.getInt(19));
                if (dx == -8388607 || dx == -9999) {
                    return -9999.0f;
                }
                return dx;
            }
            case 3: 
            case 5: 
            case 13: {
                int dx = GribNumbers.int3(this.getInt(20), this.getInt(21), this.getInt(22));
                if (dx == -8388607 || dx == -9999) {
                    return -9999.0f;
                }
                return dx;
            }
            case 1: 
            case 6: {
                int dx = GribNumbers.int3(this.getInt(28), this.getInt(29), this.getInt(30));
                if (dx == -8388607 || dx == -9999) {
                    return -9999.0f;
                }
                return dx;
            }
        }
        return -9999.0f;
    }

    public final float getDy() {
        switch (this.gdtn) {
            case 0: 
            case 10: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                int dy = GribNumbers.int2(this.getInt(25), this.getInt(26));
                if (dy == -1 || dy == -9999) {
                    return -9999.0f;
                }
                return (float)dy / 1000.0f;
            }
            case 4: 
            case 14: {
                int dy = GribNumbers.int2(this.getInt(25), this.getInt(26));
                if (dy == -1 || dy == -9999) {
                    return -9999.0f;
                }
                return dy;
            }
            case 90: {
                int dy = GribNumbers.int3(this.getInt(20), this.getInt(21), this.getInt(22));
                if (dy == -8388607 || dy == -9999) {
                    return -9999.0f;
                }
                return dy;
            }
            case 3: 
            case 5: 
            case 13: {
                int dy = GribNumbers.int3(this.getInt(23), this.getInt(24), this.getInt(25));
                if (dy == -8388607 || dy == -9999) {
                    return -9999.0f;
                }
                return dy;
            }
            case 1: 
            case 6: {
                int dy = GribNumbers.int3(this.getInt(31), this.getInt(32), this.getInt(33));
                if (dy == -8388607 || dy == -9999) {
                    return -9999.0f;
                }
                return dy;
            }
        }
        return -9999.0f;
    }

    public final float getXp() {
        switch (this.gdtn) {
            case 90: {
                return GribNumbers.int2(this.getInt(23), this.getInt(24));
            }
        }
        return -9999.0f;
    }

    public final float getYp() {
        switch (this.gdtn) {
            case 90: {
                return GribNumbers.int2(this.getInt(25), this.getInt(26));
            }
        }
        return -9999.0f;
    }

    public final int getProjectionFlag() {
        switch (this.gdtn) {
            case 3: 
            case 5: 
            case 13: {
                return this.getInt(26);
            }
        }
        return -9999;
    }

    public final int getScanMode() {
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 90: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: {
                return this.getInt(27) & 0xE0;
            }
        }
        return -9999;
    }

    public final int getAngle() {
        switch (this.gdtn) {
            case 90: {
                return GribNumbers.int3(this.getInt(28), this.getInt(29), this.getInt(30));
            }
        }
        return -9999;
    }

    public final float getNr() {
        switch (this.gdtn) {
            case 90: {
                return GribNumbers.int3(this.getInt(31), this.getInt(32), this.getInt(33));
            }
        }
        return -9999.0f;
    }

    public final float getLatin1() {
        switch (this.gdtn) {
            case 1: 
            case 6: {
                return (float)GribNumbers.int3(this.getInt(23), this.getInt(24), this.getInt(25)) / 1000.0f;
            }
            case 3: 
            case 13: {
                return (float)GribNumbers.int3(this.getInt(28), this.getInt(29), this.getInt(30)) / 1000.0f;
            }
        }
        return -9999.0f;
    }

    public final float getLatin2() {
        switch (this.gdtn) {
            case 3: 
            case 13: {
                return (float)GribNumbers.int3(this.getInt(31), this.getInt(32), this.getInt(33)) / 1000.0f;
            }
        }
        return -9999.0f;
    }

    public final float getSpLat() {
        switch (this.gdtn) {
            case 3: 
            case 13: {
                return (float)GribNumbers.int3(this.getInt(34), this.getInt(35), this.getInt(36)) / 1000.0f;
            }
            case 10: {
                return (float)GribNumbers.int3(this.getInt(32), this.getInt(33), this.getInt(34)) / 1000.0f;
            }
        }
        return -9999.0f;
    }

    public final float getSpLon() {
        switch (this.gdtn) {
            case 3: 
            case 13: {
                return (float)GribNumbers.int3(this.getInt(37), this.getInt(38), this.getInt(39)) / 1000.0f;
            }
            case 10: {
                return (float)GribNumbers.int3(this.getInt(35), this.getInt(36), this.getInt(37)) / 1000.0f;
            }
        }
        return -9999.0f;
    }

    public final String getGridUnits() {
        switch (this.gdtn) {
            case 0: 
            case 4: 
            case 10: 
            case 14: 
            case 20: 
            case 24: 
            case 30: 
            case 34: 
            case 201: 
            case 202: 
            case 203: 
            case 205: {
                return "degrees";
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 13: {
                return "m";
            }
        }
        return "";
    }

    public final int getGdsKey() {
        return this.gdsKey;
    }

    public final int get80TypeGdsKey() {
        double checkSum = this.gdtn;
        checkSum = 7.0 * checkSum + (double)this.get80La1();
        checkSum = 7.0 * checkSum + (double)this.get80Lo1();
        return Double.toString(checkSum).hashCode();
    }

    public final float getMajorAxis() {
        return 6378.16f;
    }

    public final float getMinorAxis() {
        return 6356.775f;
    }

    public final float getEarthRadius() {
        return 6367.47f;
    }

    public final int getOlon() {
        return -9999;
    }

    public final int getIolon() {
        return -9999;
    }

    public final int getShape() {
        int res = this.getResolution() >> 6;
        if (res == 1 || res == 3) {
            return 1;
        }
        return 0;
    }

    public final int getSource() {
        return -9999;
    }

    public final int getNumberPoints() {
        return -9999;
    }

    public final int getBasicAngle() {
        return -9999;
    }

    public final int getSubDivisions() {
        return -9999;
    }

    public final float getLaD() {
        return -9999.0f;
    }

    public final int getNp() {
        switch (this.gdtn) {
            case 4: 
            case 14: 
            case 24: 
            case 34: {
                int np = GribNumbers.int2(this.getInt(25), this.getInt(26));
                if (np == -1 || np == -9999) {
                    return -9999;
                }
                return np;
            }
        }
        return -9999;
    }

    public final float getXo() {
        return -9999.0f;
    }

    public final float getYo() {
        return -9999.0f;
    }

    public final float getRotationAngle() {
        switch (this.gdtn) {
            case 10: {
                return GribNumbers.float4(this.getInt(38), this.getInt(39), this.getInt(40), this.getInt(41));
            }
        }
        return -9999.0f;
    }

    public final float getPoleLat() {
        return -9999.0f;
    }

    public final float getPoleLon() {
        return -9999.0f;
    }

    public final float getStretchingFactor() {
        return -9999.0f;
    }

    public final int[] getParallels() {
        int numPts = (this.getScanMode() & 0x20) == 0 ? this.getNy() : this.getNx();
        log.debug("GDS  numPts = " + numPts);
        int[] parallels = new int[numPts];
        int offset = this.getPVorPL() - 1;
        for (int i = 0; i < numPts; ++i) {
            parallels[i] = GribNumbers.int2(this.getInt(offset++), this.getInt(offset++));
            log.debug("parallel =" + i + " number pts =" + parallels[i]);
        }
        return parallels;
    }

    private int calculateNx() {
        int numPts = (this.getScanMode() & 0x20) == 0 ? this.getNy() : this.getNx();
        int maxPts = 0;
        int[] numPV = new int[numPts];
        int offset = this.getPVorPL() - 1;
        for (int i = 0; i < numPts; ++i) {
            numPV[i] = GribNumbers.int2(this.getInt(offset++), this.getInt(offset++));
            if (maxPts >= numPV[i]) continue;
            maxPts = numPV[i];
        }
        return maxPts;
    }

    private float calculateDx() {
        float lon1;
        float lon2 = this.getLo2();
        if (lon2 < (lon1 = this.getLo1())) {
            lon2 += 360.0f;
        }
        return (lon2 - lon1) / (float)(this.getNx() - 1);
    }

    public final double[] getVerticalPressureLevels(double levelValue) {
        int offset = this.getPVorPL() - 1;
        int NV = this.getNV();
        float[] numPV = new float[NV];
        for (int i = 0; i < NV; ++i) {
            numPV[i] = GribNumbers.float4(this.getInt(offset++), this.getInt(offset++), this.getInt(offset++), this.getInt(offset++));
        }
        int nlevels = NV / 2;
        double[] pressurekp5 = new double[nlevels];
        for (int i = 0; i < nlevels; ++i) {
            pressurekp5[i] = (double)numPV[i] + (double)numPV[i + nlevels] * levelValue;
        }
        double[] pressureLevel = new double[nlevels - 1];
        for (int i = 0; i < nlevels - 1; ++i) {
            pressureLevel[i] = (pressurekp5[i] + pressurekp5[i + 1]) * 0.5;
        }
        return pressureLevel;
    }

    public final double[] getVerticalPressureLevels() {
        int offset = this.getPVorPL() - 1;
        int NV = this.getNV();
        double[] numPV = new double[NV];
        for (int i = 0; i < NV; ++i) {
            numPV[i] = GribNumbers.float4(this.getInt(offset++), this.getInt(offset++), this.getInt(offset++), this.getInt(offset++));
        }
        return numPV;
    }

    public final int getInt(int index) {
        return this.input[index] & 0xFF;
    }
}

