/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf;

import java.util.Iterator;
import java.util.NoSuchElementException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.data.netcdf.Quantity;
import visad.data.netcdf.UnsupportedOperationException;
import visad.data.units.NoSuchUnitException;
import visad.data.units.ParseException;
import visad.data.units.Parser;

public abstract class QuantityDB {
    public static final QuantityDB emptyDB;

    public abstract Quantity get(String var1);

    public abstract Quantity[] get(Unit var1);

    public synchronized Quantity get(String name, String unitSpec) throws ParseException, NoSuchUnitException, UnitException, VisADException {
        Quantity quantity = this.get(name);
        if (quantity == null) {
            quantity = new Quantity(name, unitSpec);
            this.add(quantity);
        } else {
            Unit quantityUnit = quantity.getDefaultUnit();
            if (!Unit.canConvert(Parser.parse(unitSpec), quantityUnit)) {
                throw new UnitException("Quantity " + name + " already exists; its unit " + quantity.getDefaultUnitString() + " is inconvertible with " + unitSpec);
            }
        }
        return quantity;
    }

    public abstract void add(String var1, Quantity var2) throws VisADException;

    public void add(Quantity quantity) throws VisADException {
        this.add(quantity.getName(), quantity);
    }

    public abstract Iterator quantityIterator();

    public abstract Iterator nameIterator();

    static {
        try {
            emptyDB = new QuantityDB(){

                public Quantity get(String name) {
                    return null;
                }

                public Quantity[] get(Unit unit) {
                    return null;
                }

                public void add(String name, Quantity quantity) {
                    throw new UnsupportedOperationException();
                }

                public Iterator quantityIterator() {
                    return NilIterator.INSTANCE;
                }

                public Iterator nameIterator() {
                    return NilIterator.INSTANCE;
                }
            };
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError();
        }
    }

    static class NilIterator
    implements Iterator {
        static final NilIterator INSTANCE = new NilIterator();

        private NilIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

