/*=============================================================================

    This file is part of FLINT.

    FLINT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    FLINT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FLINT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

=============================================================================*/
/******************************************************************************

    Copyright (C) 2011 Fredrik Johansson

******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <gmp.h>
#include "flint.h"
#include "fmpz.h"
#include "fmpz_poly.h"
#include "nmod_poly.h"
#include "ulong_extras.h"

int
main(void)
{
    int i;
    FLINT_TEST_INIT(state);
    

    flint_printf("get/set_nmod_poly....");
    fflush(stdout);

    for (i = 0; i < 1000 * flint_test_multiplier(); i++)
    {
        fmpz_poly_t A;
        nmod_poly_t M, M2;
        slong length;
        mp_limb_t mod;

        length = n_randint(state, 50);

        mod = n_randtest_prime(state, 0);

        nmod_poly_init(M, mod);
        nmod_poly_init(M2, mod);
        fmpz_poly_init(A);

        nmod_poly_randtest(M, state, length);

        if (i % 2 == 0)
            fmpz_poly_set_nmod_poly(A, M);
        else
            fmpz_poly_set_nmod_poly_unsigned(A, M);

        fmpz_poly_scalar_mul_ui(A, A, UWORD(2));
        nmod_poly_add(M, M, M);
        fmpz_poly_get_nmod_poly(M2, A);

        if (!nmod_poly_equal(M, M2))
        {
            flint_printf("FAIL!\n");
            abort();
        }

        fmpz_poly_clear(A);
        nmod_poly_clear(M);
        nmod_poly_clear(M2);
    }

    

    FLINT_TEST_CLEANUP(state);
    flint_printf("PASS\n");
    return 0;
}
