/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define __EVENT_H

typedef struct event event;
typedef struct event_list event_list;

#ifndef __SAMPLE_PRODUCER_H
  #include "sample_producer.h"
#endif

#ifndef __SEQ_H
 #include "sequencer.h"
#endif

struct sample_producer;

struct event{
  int seq_handle;
  void (*fire)(struct event *this, struct sample_producer *target);
};


event *event_new_trigger();



struct event_list{
  int length;
  int size;
  event **events;
};


event_list *event_list_new();
void event_list_add(event_list *this,event *e);
void event_list_remove(event_list *this, event *e);



typedef struct event_bookeeper{
  int step;
  event_list *last_events;
  int seq_handle; /*seq event handle */
}event_bookeeper;

event_bookeeper *e_bookeeper_new(int step, int seq_handle);
void clean_bookeeper(event_bookeeper *eb, seq *sequencer);

/*
  Local Variables:
  mode: font-lock
  End:
*/








