/*
 * Copyright (C) 2022-2023 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#include "shared/test/common/os_interface/linux/device_command_stream_fixture_prelim.h"
#include "shared/test/common/os_interface/linux/drm_buffer_object_fixture.h"
#include "shared/test/common/test_macros/test.h"

using namespace NEO;

using DrmBufferObjectPrelimFixture = DrmBufferObjectFixture<DrmMockCustomPrelim>;
using DrmBufferObjectPrelimTest = Test<DrmBufferObjectPrelimFixture>;

TEST_F(DrmBufferObjectPrelimTest, GivenCompletionAddressWhenCallingExecThenReturnIsCorrect) {
    mock->ioctlExpected.total = 1;
    mock->ioctlRes = 0;

    constexpr uint64_t completionAddress = 0x1230;
    constexpr uint32_t completionValue = 33;
    constexpr uint64_t expectedCompletionValue = completionValue;

    ExecObject execObjectsStorage = {};
    auto ret = bo->exec(0, 0, 0, false, osContext.get(), 0, 1, nullptr, 0u, &execObjectsStorage, completionAddress, completionValue);
    EXPECT_EQ(0, ret);
    EXPECT_EQ(completionAddress, mock->context.completionAddress);
    EXPECT_EQ(expectedCompletionValue, mock->context.completionValue);
}
