
(* The type of tokens. *)

type token = 
  | YIELDS
  | WHILE
  | WAV
  | VORBIS_CBR
  | VORBIS_ABR
  | VORBIS
  | VIDEO_RAW
  | VIDEO_NONE
  | VIDEO_COPY
  | VIDEO
  | VARLPAR of (string)
  | VARLBRA of (string)
  | VAR of (string)
  | UNDERSCORE
  | UMINUS
  | TRY
  | TO
  | TIMES
  | TIME of (int option list)
  | TILD
  | THEORA
  | THEN
  | STRING of (string)
  | SPEEX
  | SHINE
  | SET
  | SEQSEQ
  | SEQ
  | RPAR
  | REPLACES
  | REC
  | RCUR
  | RBRA
  | QUESTION
  | PP_STRING of (string * (Lexing.position * Lexing.position))
  | PP_INT_DOT_LCUR of (int)
  | PP_INCLUDE of (string)
  | PP_IFVERSION of ([ `Eq | `Geq | `Leq | `Gt | `Lt] * string)
  | PP_IFNENCODER
  | PP_IFNDEF of (string)
  | PP_IFENCODER
  | PP_IFDEF of (string)
  | PP_ENDL
  | PP_ENDIF
  | PP_ELSE
  | PP_DEFINE
  | PP_DEF
  | PP_COMMENT of (string list)
  | OPUS
  | OPEN
  | OGG
  | NOT
  | MP3_VBR
  | MP3_ABR
  | MP3
  | MINUS
  | LPAR
  | LET
  | LCUR
  | LBRA
  | INTERVAL of (int option list * int option list)
  | INT of (int)
  | IF
  | GSTREAMER
  | GETS
  | GET
  | FUN
  | FOR
  | FLOAT of (float)
  | FLAC
  | FFMPEG
  | FDKAAC
  | EXTERNAL
  | EOF
  | END
  | ELSIF
  | ELSE
  | DOTDOTDOT
  | DOT
  | DO
  | DEF of (Doc.item * (string*string) list * (string*string) list)
  | COMMA
  | COLON
  | COALESCE
  | CATCH
  | BOOL of (bool)
  | BINB of (string)
  | BIN3 of (string)
  | BIN2 of (string)
  | BIN1 of (string)
  | BEGIN
  | AVI
  | AUDIO_RAW
  | AUDIO_NONE
  | AUDIO_COPY
  | AUDIO
  | ARGS_OF

(* This exception is raised by the monolithic API functions. *)

exception Error

(* The monolithic API. *)

val time_predicate: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Term.t)

val program: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Term.t)

val interactive: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Term.t)

val annotate: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> ((string * string) list)
