#if !defined (__CORELINUXOBJECT_HPP)
#define __CORELINUXOBJECT_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if !defined IN_COMMON_HPP
   #error except.hpp is included by common.hpp only.
#endif


namespace corelinux
{

   DECLARE_CLASS( CoreLinuxObject );

   /**
   An CoreLinuxObject is a base class for the library. It is used
   to provide coherence in other implementations.
   */

   class CoreLinuxObject
   {
   public:

                           /// Default Constructor

                           CoreLinuxObject( void );

                           /** Copy Constructor
                           @param CoreLinuxObject const reference
                           */

                           CoreLinuxObject( CoreLinuxObjectCref );

                           /// Virtual Destructor  

      virtual              ~CoreLinuxObject( void );

      //
      // Operator overloads
      //
               /**
               Assignment operator overload
               @param  CoreLinuxObject const reference
               @return CoreLinuxObject reference to self
               */
            
               CoreLinuxObjectRef  operator=( CoreLinuxObjectCref );

               /**
               Equality operator overload
               @param CoreLinuxObject const reference
               @return true if equal, false otherwise
               */

               bool        operator==( CoreLinuxObjectCref ) const;

               /**
               Non-equality operator overload
               @param CoreLinuxObject const reference
               @return false if equal, true otherwise
               */

               bool        operator!=( CoreLinuxObjectCref ) const;

   };

}
          
#endif   // if !defined(__CORELINUXOBJECT_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/05/12 03:27:47 $
   $Locker:  $
*/

