#!/bin/sh

. ../GNATCOLL_CONFIG

print_header "GMP"

echo > log.txt

gnatmake -q -p -P gmp_tests.gpr -XGNATCOLL_KIND=${LIBRARY_TYPE}

$valgrind ./test_eq >> log.txt
$valgrind ./test_image >> log.txt
$valgrind ./test_swap >> log.txt
$valgrind ./test_roots >> log.txt
$valgrind ./test_pow >> log.txt
$valgrind ./test_div >> log.txt
$valgrind ./test_rem >> log.txt
$valgrind ./test_mod >> log.txt
$valgrind ./test_gcd >> log.txt
$valgrind ./test_operators >> log.txt

tr -d '\r' < log.txt > log.txt.nocr
diff log_reference.txt log.txt.nocr >/dev/null
if [ $? -ne 0 ]; then
  print_status 1
  diff log_reference.txt log.txt.nocr
fi

rm -f log.txt log.txt.nocr
print_status 0
