message("UNIX non APPLE environment")
message("Please run the configuration like this:")
message("cmake -G \"Unix Makefiles\" -DCMAKE_BUILD_TYPE=Debug ../development")

#set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)
#set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)

set(LINKER_FLAGS "-Wl,--no-as-needed")

##############################################################################
################################  ATTENTION  #################################
# When adding new library dependencies, in order to make them discoverable
# by libraries/programs that use *this* library, please ensure that you
# add the corresponding name to file CMakeStuff/modules/PappsoMSppConfig.cmake.in
##############################################################################
################################  ATTENTION  #################################


find_package(Qt6 COMPONENTS Widgets Core Gui PrintSupport Svg Xml Sql Concurrent Core5Compat Qml REQUIRED)

# debian package : libboost-container-dev
find_package(
    Boost
    COMPONENTS chrono
               container
               filesystem
               iostreams
               thread
    REQUIRED
)

find_package(PwizLite REQUIRED)

find_package(ZLIB REQUIRED)

find_package(Zstd REQUIRED)

find_package(liblzf REQUIRED)

find_package(QuaZip-Qt6 REQUIRED)

find_package(OdsStream COMPONENTS Core)

if(NEEDHDF5)
  include(FindHDF5)
  find_package(HDF5 COMPONENTS CXX)

  #message(STATUS "HDF5_LIBRARIES: ${HDF5_LIBRARIES}")
  message(STATUS "HDF5_CXX_LIBRARIES: ${HDF5_CXX_LIBRARIES}")
  #message(STATUS "HDF5_INCLUDE_DIRS: ${HDF5_INCLUDE_DIRS}")
  message(STATUS "HDF5_CXX_INCLUDE_DIRS: ${HDF5_CXX_INCLUDE_DIRS}")
endif(NEEDHDF5)

find_package(QCustomPlotQt6 REQUIRED)
# Per instructions of the lib author:
# https://www.qcustomplot.com/index.php/tutorials/settingup
message(STATUS "Setting definition -DQCUSTOMPLOT_USE_LIBRARY.")

find_package(Catch2)
message("Catch2 major version found: " ${Catch2_VERSION_MAJOR})
add_compile_definitions(CATCH2_MAJOR_VERSION_${Catch2_VERSION_MAJOR})

if(MAKE_TESTS)
    message(STATUS "MAKE_TESTS: ${MAKE_TESTS}")
    # No need to find QuaZip-Qt6 because OdsStream had done that already.
    # find_package(QuaZip-Qt6 REQUIRED)
endif(MAKE_TESTS)

add_definitions(-fPIC)

message("unix-toolchain.cmake - LOCAL_CMAKE_MODULE_PATH: ${LOCAL_CMAKE_MODULE_PATH}")


get_deb_triplet_string(DEB_TRIPLET_STRING)

if(NOT "${CMAKE_LIBRARY_ARCHITECTURE}" STREQUAL "${DEB_TRIPLET_STRING}")
    message(FATAL_ERROR "Odd situation where CMAKE_LIBRARY_ARCHITECTURE is not equal to DEB_TRIPLET_STRING")
endif()

if(DEB_TRIPLET_STRING)
    set(CMAKE_INSTALL_TRIPLET_LIBDIR ${CMAKE_INSTALL_LIBDIR}/${DEB_TRIPLET_STRING})
    set(CMAKE_INSTALL_FULL_TRIPLET_LIBDIR ${CMAKE_INSTALL_FULL_LIBDIR}/${DEB_TRIPLET_STRING})
endif()

message(STATUS "The install library is set to ${CMAKE_INSTALL_LIBDIR}")
message(STATUS "The full install library is set to ${CMAKE_INSTALL_FULL_LIBDIR}")

message(STATUS "The install triplet library is set to ${CMAKE_INSTALL_TRIPLET_LIBDIR}")
message(STATUS "The full install triplet library is set to ${CMAKE_INSTALL_FULL_TRIPLET_LIBDIR}")

# Install the cmake module
message("LOCAL_CMAKE_MODULE_PATH: ${LOCAL_CMAKE_MODULE_PATH}")

install(
    FILES ${LOCAL_CMAKE_MODULE_PATH}/FindPappsoMSpp.cmake
    DESTINATION ${CMAKE_INSTALL_LIBDIR}/cmake/pappsomspp
)

# The configure_package_config_file() call for
# ${CMAKE_UTILS_PATH}/modules/PappsoMSppConfig.cmake.in
# now occurs at the end of the src/CMakeLists.txt file
