/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ColorButton_p.h"

#include "RgbaDialog_p.h"

#include <QPainter>

using namespace QtShiva;

ColorButton::ColorButton( QWidget* _parent, bool _showAlpha ) : QPushButton( _parent ), m_showAlpha(_showAlpha)
{
  connect( this, SIGNAL(released()), SLOT(activated()));
}

ColorButton::~ColorButton()
{
}

#include <iostream>

void ColorButton::setCurrentColor( const QColor& _color )
{
  m_color = _color;
  QPixmap px( 100, 30 );
  QPainter pa( &px );
  pa.fillRect( 0, 0, 100, 30, _color );
  setIcon(px);
  emit(colorChanged( m_color ) );
}

const QColor& ColorButton::currentColor() const
{
  return m_color;
}

void ColorButton::activated()
{
  RgbaDialog dialog( this, m_showAlpha );
  dialog.setColor( m_color );
  if(dialog.exec() == QDialog::Accepted )
  {
    setCurrentColor( dialog.color() );
  }
}

#include "ColorButton_p.moc"
