# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.point_set_algorithm import PointSetAlgorithm


class AppendDataSets(PointSetAlgorithm):
    r"""
    AppendDataSets - Appends one or more datasets together into a
    single output PointSet.
    
    Superclass: PointSetAlgorithm
    
    AppendDataSets is a filter that appends one of more datasets into
    a single output point set. The type of the output is set with the
    output_data_set_type option. Only inputs that can be converted to the
    selected output dataset type are appended to the output. By default,
    the output is UnstructuredGrid, and all input types can be
    appended to it. If the output_data_set_type is set to produce
    PolyData, then only datasets that can be converted to PolyData
    (i.e., PolyData) are appended to the output.
    
    All cells are extracted and appended, but point and cell attributes
    (i.e., scalars, vectors, normals, field data, etc.) are extracted and
    appended only if all datasets have the same point and/or cell
    attributes available. (For example, if one dataset has scalars but
    another does not, scalars will not be appended.)
    
    Points can be merged if merge_points is set to true. In this case,
    points are really merged if there are no ghost cells and no global
    point ids, or if there are global point ids. In the case of the
    presence of global point ids, the filter exclusively relies on those
    ids, not checking if points are coincident. It assumes that the
    global ids were properly set. In the case of the absence of global
    ids, points withing Tolerance are merged.
    
    @sa
    AppendFilter AppendPolyData
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAppendDataSets, obj, update, **traits)
    
    merge_points = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _merge_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMergePoints,
                        self.merge_points_)

    tolerance_is_absolute = tvtk_base.true_bool_trait(desc=\
        r"""
        Get/Set whether Tolerance is treated as an absolute or relative
        tolerance. The default is to treat it as an absolute tolerance.
        When off, the tolerance is multiplied by the diagonal of the
        bounding box of the input.
        """
    )

    def _tolerance_is_absolute_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetToleranceIsAbsolute,
                        self.tolerance_is_absolute_)

    output_data_set_type = traits.Int(4, enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set the output type produced by this filter. Only input
        datasets compatible with the output type will be merged in the
        output. For example, if the output type is PolyData, then
        blocks of type ImageData, StructuredGrid, etc. will not be
        merged - only PolyData can be merged into a PolyData. On
        the other hand, if the output type is UnstructuredGrid, then
        blocks of almost any type will be merged in the output. Valid
        values are VTK_POLY_DATA and VTK_UNSTRUCTURED_GRID defined in
        Type.h. Defaults to VTK_UNSTRUCTURED_GRID.
        """
    )

    def _output_data_set_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputDataSetType,
                        self.output_data_set_type)

    output_points_precision = traits.Trait(2, traits.Range(0, 2, enter_set=True, auto_set=False), desc=\
        r"""
        Set/get the desired precision for the output types. See the
        documentation for the Algorithm::Precision enum for an
        explanation of the available precision settings.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    tolerance = traits.Trait(0.0, traits.Range(0.0, 1e+299, enter_set=True, auto_set=False), desc=\
        r"""
        Get/Set the tolerance to use to find coincident points when
        `merge_points` is `true`. Default is 0.0.
        
        This is simply passed on to the internal Locator used to merge
        points.
        @sa `Locator::set_tolerance`.
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        
        """
    )

    _updateable_traits_ = \
    (('merge_points', 'GetMergePoints'), ('tolerance_is_absolute',
    'GetToleranceIsAbsolute'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('output_data_set_type', 'GetOutputDataSetType'),
    ('output_points_precision', 'GetOutputPointsPrecision'), ('tolerance',
    'GetTolerance'), ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display', 'merge_points',
    'release_data_flag', 'tolerance_is_absolute', 'object_name',
    'output_data_set_type', 'output_points_precision', 'progress_text',
    'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AppendDataSets, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AppendDataSets properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['merge_points', 'tolerance_is_absolute'], [], ['object_name',
            'output_data_set_type', 'output_points_precision', 'tolerance']),
            title='Edit AppendDataSets properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AppendDataSets properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

