/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

package org.netbeans.modules.javawebstart.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/**
 * Signing configuration panel.
 *
 * @author Maros Sandor
 */
public class SigningPanel extends javax.swing.JPanel implements ActionListener {
    
    private final JWSProjectProperties props;

    /** Creates new form SigningPanel */
    public SigningPanel(JWSProjectProperties props) {
        this.props = props;
        initComponents();

        if (JWSProjectProperties.SIGNING_KEY.equals(props.signing)) {
            keySign.setSelected(true);
        } else if (JWSProjectProperties.SIGNING_GENERATED.equals(props.signing)) {
            selfSign.setSelected(true);
        } else {
            noSign.setSelected(true);
        }
        path.setText(props.signingKeyStore);
        key.setText(props.signingKeyAlias);
        if (props.signingKeyStorePassword != null) password.setText(new String(props.signingKeyStorePassword));
        if (props.signingKeyPassword != null) keyPass.setText(new String(props.signingKeyPassword));

        mixedCodeCombo.setModel(props.mixedCodeModel);

        refreshComponents();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        keySign.addActionListener(this);
        selfSign.addActionListener(this);
        noSign.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        refreshComponents();
    }

    private void refreshComponents() {
        path.setEnabled(keySign.isSelected());
        browse.setEnabled(keySign.isSelected());
        password.setEnabled(keySign.isSelected());
        key.setEnabled(keySign.isSelected());
        keyPass.setEnabled(keySign.isSelected());
        jLabel1.setEnabled(keySign.isSelected());
        jLabel2.setEnabled(keySign.isSelected());
        jLabel3.setEnabled(keySign.isSelected());
        jLabel4.setEnabled(keySign.isSelected());
        mixedCodeCombo.setEnabled(!noSign.isSelected());
        jLabel5.setEnabled(!noSign.isSelected());
    }

    void store() {
        if (noSign.isSelected()) {
            props.signing = "";
        } else if (selfSign.isSelected()) {
            props.signing = JWSProjectProperties.SIGNING_GENERATED;
        } else {
            props.signing = JWSProjectProperties.SIGNING_KEY;
            props.signingKeyStorePassword = password.getPassword();
            props.signingKeyPassword = keyPass.getPassword();
            props.signingKeyStore = path.getText().trim();
            props.signingKeyAlias = key.getText().trim();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        bg = new javax.swing.ButtonGroup();
        selfSign = new javax.swing.JRadioButton();
        keySign = new javax.swing.JRadioButton();
        jLabel1 = new javax.swing.JLabel();
        path = new javax.swing.JTextField();
        browse = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        password = new javax.swing.JPasswordField();
        jLabel3 = new javax.swing.JLabel();
        key = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        keyPass = new javax.swing.JPasswordField();
        noSign = new javax.swing.JRadioButton();
        mixedCodeCombo = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();

        bg.add(selfSign);
        org.openide.awt.Mnemonics.setLocalizedText(selfSign, org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.selfSign.text")); // NOI18N

        bg.add(keySign);
        org.openide.awt.Mnemonics.setLocalizedText(keySign, org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.keySign.text")); // NOI18N

        jLabel1.setLabelFor(path);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.jLabel1.text")); // NOI18N

        path.setText(org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.path.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(browse, org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.browse.text")); // NOI18N
        browse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseActionPerformed(evt);
            }
        });

        jLabel2.setLabelFor(password);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.jLabel2.text")); // NOI18N

        password.setText(org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.password.text")); // NOI18N

        jLabel3.setLabelFor(key);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.jLabel3.text")); // NOI18N

        key.setText(org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.key.text")); // NOI18N

        jLabel4.setLabelFor(keyPass);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.jLabel4.text")); // NOI18N

        keyPass.setText(org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.keyPass.text")); // NOI18N

        bg.add(noSign);
        org.openide.awt.Mnemonics.setLocalizedText(noSign, org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.noSign.text")); // NOI18N

        jLabel5.setLabelFor(mixedCodeCombo);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel5, org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.jLabel5.text")); // NOI18N
        jLabel5.setToolTipText(org.openide.util.NbBundle.getMessage(SigningPanel.class, "SigningPanel.jLabel5.toolTipText")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(noSign)
                    .addComponent(selfSign)
                    .addComponent(keySign)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(jLabel2)
                            .addComponent(jLabel3)
                            .addComponent(jLabel4)
                            .addComponent(jLabel5))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(mixedCodeCombo, 0, 415, Short.MAX_VALUE)
                            .addComponent(keyPass, javax.swing.GroupLayout.DEFAULT_SIZE, 415, Short.MAX_VALUE)
                            .addComponent(key, javax.swing.GroupLayout.DEFAULT_SIZE, 415, Short.MAX_VALUE)
                            .addComponent(password, javax.swing.GroupLayout.DEFAULT_SIZE, 415, Short.MAX_VALUE)
                            .addComponent(path, javax.swing.GroupLayout.DEFAULT_SIZE, 415, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(browse)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(noSign)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(selfSign)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(keySign)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(path, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(browse))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(password, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(key, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(keyPass, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(mixedCodeCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        selfSign.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SigningPanel.class, "AD_SigningPanel.selfSign.text")); // NOI18N
        keySign.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SigningPanel.class, "AD_SigningPanel.keySign.text")); // NOI18N
        jLabel1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SigningPanel.class, "AD_SigningPanel.jLabel1.text")); // NOI18N
        browse.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SigningPanel.class, "AD_SigningPanel.browse.text")); // NOI18N
        jLabel2.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SigningPanel.class, "AD_SigningPanel.jLabel2.text")); // NOI18N
        jLabel3.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SigningPanel.class, "AD_SigningPanel.jLabel3.text")); // NOI18N
        jLabel4.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SigningPanel.class, "AD_SigningPanel.jLabel4.text")); // NOI18N
        noSign.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SigningPanel.class, "AD_SigningPanel.noSign.text")); // NOI18N

        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SigningPanel.class, "AD_SigningPanel")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void browseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseActionPerformed
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(NbBundle.getMessage(JWSCustomizerPanel.class, "TITLE_KeystoreBrowser"));
        if (JFileChooser.APPROVE_OPTION == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile(chooser.getSelectedFile());
            path.setText(file.getAbsolutePath());
        }
    }//GEN-LAST:event_browseActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    javax.swing.ButtonGroup bg;
    javax.swing.JButton browse;
    javax.swing.JLabel jLabel1;
    javax.swing.JLabel jLabel2;
    javax.swing.JLabel jLabel3;
    javax.swing.JLabel jLabel4;
    javax.swing.JLabel jLabel5;
    javax.swing.JTextField key;
    javax.swing.JPasswordField keyPass;
    javax.swing.JRadioButton keySign;
    javax.swing.JComboBox mixedCodeCombo;
    javax.swing.JRadioButton noSign;
    javax.swing.JPasswordField password;
    javax.swing.JTextField path;
    javax.swing.JRadioButton selfSign;
    // End of variables declaration//GEN-END:variables
}
