/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2012 Sun Microsystems, Inc.
 */
package org.netbeans.modules.web.clientproject.api.network.ui;

import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

/**
 * UI for network errors.
 */
public class NetworkErrorPanel extends JPanel {

    private static final long serialVersionUID = 783521567875L;

    public static final int MAX_REQUEST_LENGTH = 80;

    private final List<String> failedRequests;


    public NetworkErrorPanel(List<String> failedRequests) {
        this.failedRequests = failedRequests;
        initComponents();

        init();
    }

    private void init() {
        String text = infoTextPane.getText();
        infoTextPane.setText(text.replace("%FAILED_REQUESTS%", joinRequests(failedRequests))); // NOI18N
        // listeners
        infoTextPane.addHyperlinkListener(new HyperlinkListener() {
            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(e.getURL());
                }
            }
        });
    }

    // unit tests
    static String joinRequests(List<String> failedRequests) {
        StringBuilder sb = new StringBuilder(200);
        for (String request : failedRequests) {
            if (request == null) {
                throw new NullPointerException("Request cannot be null");
            }
            if (sb.length() > 0) {
                sb.append("<br>"); // NOI18N
            }
            sb.append(decorateRequest(request));
        }
        return sb.toString();
    }

    // unit tests
    static String decorateRequest(String request) {
        String original = request;
        if (request.length() > MAX_REQUEST_LENGTH) {
            request = request.substring(0, MAX_REQUEST_LENGTH) + "..."; // NOI18N
        }
        if (request.startsWith("http://") // NOI18N
                || request.startsWith("https://")) { // NOI18N
            return "<a href=\"" + original + "\">" + request + "</a>"; // NOI18N
        }
        return request;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        infoScrollPane = new JScrollPane();
        infoTextPane = new JTextPane();

        infoScrollPane.setBorder(null);

        infoTextPane.setEditable(false);
        infoTextPane.setBorder(null);
        infoTextPane.setContentType("text/html"); // NOI18N
        infoTextPane.setText(NbBundle.getMessage(NetworkErrorPanel.class, "NetworkErrorPanel.infoTextPane.text")); // NOI18N
        infoTextPane.setOpaque(false);
        infoScrollPane.setViewportView(infoTextPane);

        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(infoScrollPane)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(infoScrollPane)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JScrollPane infoScrollPane;
    private JTextPane infoTextPane;
    // End of variables declaration//GEN-END:variables
}
