# Jasmine Core 2.2.0 Release Notes

## Changes

* `ObjectContaining` no longer tries to track exact mismatches
* HTML reporter keeps extra query params when focusing on a spec or suite 
* Check custom properties on Arrays when computing equality
* Better error message if `spyOn` is called without a method name
* Rename `jasmineMatches` to `asymmetricMatch`
* Don't double escape focus spec links
* Jasmine equality checks if either side implements `asymmetricMatch`
* Add asymmetric equality tester to match a string with a RegExp
* Add jshint to node build on Travis for pull request builds
* Restructure node examples directory to look more realistic

## Pull Requests & Issues

* Add a basic bower config
    - Fixes [#719](https://github.com/jasmine/jasmine/issues/719)

* Allow `pending` to take a reason and show it in the HtmlReporter
    - Fixes [#671](https://github.com/jasmine/jasmine/issues/671)

* Set jasmineGlobal correctly in GJS
    - Merges [#757](https://github.com/jasmine/jasmine/issues/757) from @ptomato
    - Fixes [#751](https://github.com/jasmine/jasmine/issues/751)

* Fix some SpiderMonkey lint warnings
    - Merges [#752](https://github.com/jasmine/jasmine/issues/752) from @ptomato
    - Fixes [#751](https://github.com/jasmine/jasmine/issues/751)

* Prevents *Alls from running when runnables are explicitly set
    - Fixes [#732](https://github.com/jasmine/jasmine/issues/732)

* Update contribution guide to mention possible ffi dependencies for Ubuntu
    - Fixes [#755](https://github.com/jasmine/jasmine/issues/755)

* Fix spelling mistake in contributors guide
    - Merges [#746](https://github.com/jasmine/jasmine/issues/746) from @swirlycheetah

* Use new jasmine github repo url
    - Merges [#745](https://github.com/jasmine/jasmine/issues/745) rohit

* Allow `createSpyObj` to be called with just an array of method names
    - Fixes [#321](https://github.com/jasmine/jasmine/issues/321)

* Add `arrayContaining` matcher
    - Merges [#440](https://github.com/jasmine/jasmine/issues/440) from @slackersoft

* Use the stack trace from the Error object if supplied
    - Fixes [#734](https://github.com/jasmine/jasmine/issues/734)

* Update readme with link to upgrading doc and mention browser support.
    - Fixes [#739](https://github.com/jasmine/jasmine/issues/739)

* Link to the Jasmine NPM module
    - Merges [#736](https://github.com/jasmine/jasmine/issues/736) from @moonmaster9000

* Allow null prototype objects to be compared for equality
    - Merges [#731](https://github.com/jasmine/jasmine/issues/731) from @rohit
    - Fixes [#729](https://github.com/jasmine/jasmine/issues/729)

* Fix URL's of Jasmine repositories on Github
    - Merges [#730](https://github.com/jasmine/jasmine/issues/730) from @rohit

* Add `anything` matcher to match any value that is neither null or undefined
    - Fixes [#186](https://github.com/jasmine/jasmine/issues/186)

* Allow asymmetric equality testers to preempt their symmetric brethren
    - Fixes [#540](https://github.com/jasmine/jasmine/issues/540)

* Check for `ObjectContaining` on either side of equality
    - Fixes [#682](https://github.com/jasmine/jasmine/issues/682)

* Display the name of the constructor when pretty printing objects
    - Fixes [#598](https://github.com/jasmine/jasmine/issues/598)

* `toMatch` requires the `expected` to be a String or RegExp
    - Fixes [#723](https://github.com/jasmine/jasmine/issues/723)

* Better equality comparison of Dom nodes
    - Merges [#657](https://github.com/jasmine/jasmine/issues/657) from @alexeibs

* Hide unnecessary files from the npm package
    - Fixes [#726](https://github.com/jasmine/jasmine/issues/726)

* Properly record finishing an `xdescribe` so further cleanup works
    - Fixes [#724](https://github.com/jasmine/jasmine/issues/724)

* Reschedule all functions for a tick before executing any. This allows any function run during a tick to cancel any other in the same tick.
    - Fixes [#708](https://github.com/jasmine/jasmine/issues/708)

* Pass through all args from external interface for befores, afters, its
    - Fixes [#483](https://github.com/jasmine/jasmine/issues/483)

------

_Release Notes generated with _[Anchorman](http://github.com/infews/anchorman)_
