/* NVTV I2C wrapper header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: tv_i2c.h,v 1.8 2004/01/27 17:05:25 dthierbach Exp $
 *
 * Contents:
 *
 * I2C wrapper for the TV-I2C routines.
 *
 */

#ifndef _TV_I2C_H
#define _TV_I2C_H

#include "xf86i2c.h"

extern Bool tvBusOk;

Bool TVProbeBus (I2CBusPtr bus, I2CSlaveAddr addr);
void TVWriteBus (I2CDevPtr d, I2CByte subaddr, I2CByte data);
void TVWriteSeqBus (I2CDevPtr d, I2CByte subaddr, I2CByte *buf, int len);
void TVReadBus (I2CDevPtr d, I2CByte subaddr, I2CByte *data);
void TVReadSeqBus (I2CDevPtr d, I2CByte subaddr, I2CByte *data, int len);
void TVStatusBus (I2CDevPtr d, I2CByte *data);
void TVStatusSeqBus (I2CDevPtr d, I2CByte *buf, int len);

#endif /* _TV_I2C_H */
