/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.util;

import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.SimpleDateFormat;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

public class EmbeddedAnno {
    private String mAnnotation = "";
    private String mUser = "";
    private String mDate = "";
    private String mXMLHeader = "<?xml version=\"1.0\"?>";

    public EmbeddedAnno(String data) {
        if (data.indexOf("<?xml") < 0) {
            this.parseString(this.mXMLHeader + data);
        } else {
            this.parseString(data);
        }
    }

    public EmbeddedAnno() {
    }

    public EmbeddedAnno(String user, String date, String anno) {
        this.mUser = user;
        this.mDate = date;
        this.mAnnotation = anno;
    }

    public EmbeddedAnno(String user, String anno) {
        this.mUser = user;
        SimpleDateFormat sdf = new SimpleDateFormat();
        this.mDate = sdf.getCurrentDateTimeAsString();
        this.mAnnotation = anno;
    }

    public String toString() {
        String ret = "";
        StringWriter writer = new StringWriter();
        try {
            Marshaller.marshal((Object)this, (Writer)writer);
            ret = writer.toString();
            ret = ret.substring(this.mXMLHeader.length());
        }
        catch (ValidationException vex) {
            Logger log = LoggerUtils.getLogger(this);
            log.severe("Marshalling validation exception " + vex.getMessage());
        }
        catch (MarshalException mex) {
            Logger log = LoggerUtils.getLogger(this);
            log.severe("Marshalling exception " + mex.getMessage());
        }
        Logger log = LoggerUtils.getLogger(this);
        log.info("**EMBEDDDEDANNO toString" + ret);
        return ret;
    }

    public String getUser() {
        return this.mUser;
    }

    public String getDate() {
        return this.mDate;
    }

    public String getNote() {
        return this.mAnnotation;
    }

    public void setUser(String user) {
        this.mUser = user;
    }

    public void setDate(String date) {
        this.mDate = date;
    }

    public void setNote(String note) {
        this.mAnnotation = note;
    }

    protected void parseString(String data) {
        this.mUser = "";
        this.mDate = "";
        this.mAnnotation = "";
        try {
            Logger log = LoggerUtils.getLogger(this);
            log.info("parse **EMBEDDDEDANNO " + data);
            EmbeddedAnno tmp = (EmbeddedAnno)Unmarshaller.unmarshal(EmbeddedAnno.class, (Reader)new StringReader(data));
            this.setNote(tmp.getNote());
            this.setUser(tmp.getUser());
            this.setDate(tmp.getDate());
        }
        catch (MarshalException mex) {
            Logger log = LoggerUtils.getLogger(this);
            log.severe("Unmarshall error " + mex.getMessage());
        }
        catch (ValidationException vex) {
            Logger log = LoggerUtils.getLogger(this);
            log.severe("Unmarshall validation error " + vex.getMessage());
        }
    }
}

