/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi;

import com.sourceforge.knecs.dsm.authorization.AccessException;
import com.sourceforge.knecs.dsm.authorization.DSIAuthService;
import com.sourceforge.knecs.dsm.authorization.DSIPrivilege;
import com.sourceforge.knecs.dsm.authorization.NormalizedAceList;
import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.DSIPool;
import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.dsm.dsi.StatusException;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.webdav.lib.Privilege;

public class DSIAdmin {
    private String mUser = null;
    private String mAuth = null;
    private static Logger mLogger = null;
    public static String SERVER_URL;

    public DSIAdmin(String username, String password) {
        this.mUser = username;
        this.mAuth = password;
        mLogger = LoggerUtils.getLogger(this);
    }

    protected DSI getDSI(String url) {
        return DSIPool.getDSIPool().getConnection(url, this.mUser, this.mAuth);
    }

    protected void releaseDSI(DSI dsi) {
        DSIPool.getDSIPool().release(dsi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUser(String userID, String password) throws StatusException, AccessException {
        mLogger.fine("Trying to create user principal /users/" + userID + " on slide server");
        String userPrin = DSIAdmin.getPrincipalDir(userID);
        DSI dsi = this.getDSI(userPrin);
        try {
            if (dsi.exists()) {
                mLogger.fine("User already exists!");
                CMCSProperties props = CMCSProperties.getCMCSProperties();
                NSProperty nsProp = new NSProperty((String)props.get("slidens"), "password");
                DSIProperty prop = dsi.getMetaData(nsProp);
                if (!prop.getPropertyAsString().equals(password)) {
                    throw new AccessException("Cannot create user " + userID + ".  This user already exists and has a different password!");
                }
            } else {
                String tempDir = DSIAdmin.getTemplateUserDir();
                dsi.setURL(tempDir);
                dsi.copy("/users/" + userID);
                String userHome = DSIAdmin.getUserHomeDir(userID);
                String homeDir = DSIAdmin.getUsersRootDir();
                dsi.setURL(userHome);
                if (!dsi.exists()) {
                    mLogger.fine("Creating directory: " + userHome);
                    dsi.setURL(homeDir);
                    dsi.makeCollection(userID);
                }
                DSIAuthService authService = new DSIAuthService(dsi);
                authService.addPrivilege(Privilege.ALL, homeDir + "/" + userID, userID);
                authService.close();
                authService = null;
                this.changePassword(userID, password);
            }
            mLogger.fine("User creation successful");
        }
        finally {
            this.releaseDSI(dsi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String userID) throws StatusException, AccessException {
        String userHome = DSIAdmin.getUserHomeDir(userID);
        DSI dsi = this.getDSI(userHome);
        try {
            if (dsi.exists()) {
                mLogger.fine("Removing directory: " + userHome);
                dsi.removeResource();
            }
            String userPrincipal = DSIAdmin.getPrincipalDir(userID);
            dsi.setURL(userPrincipal);
            if (dsi.exists()) {
                mLogger.fine("Removing directory: " + userPrincipal);
                dsi.removeResource();
            }
        }
        finally {
            this.releaseDSI(dsi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String userID, String password) throws StatusException {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        NSProperty nsProp = new NSProperty((String)props.get("slidens"), "password");
        String userPrincipal = DSIAdmin.getPrincipalDir(userID);
        DSI dsi = this.getDSI(userPrincipal);
        try {
            dsi.putMetaData(nsProp, password);
        }
        finally {
            this.releaseDSI(dsi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup(String groupID, String leaderID) throws StatusException, AccessException {
        String groupHome = DSIAdmin.getGroupHomeDir(groupID);
        DSI dsi = this.getDSI(groupHome);
        try {
            if (dsi.exists()) {
                throw new AccessException("Group projects directory already exists!");
            }
            String groupPublic = DSIAdmin.getGroupPublicDir(groupID);
            dsi.setURL(groupPublic);
            if (dsi.exists()) {
                throw new AccessException("Group public directory already exists!");
            }
            String projDir = DSIAdmin.getProjectsRootDir();
            dsi.setURL(projDir);
            dsi.makeCollection(groupID);
            String pubDir = DSIAdmin.getPublicRootDir();
            dsi.setURL(pubDir);
            dsi.makeCollection(groupID);
            this.addGroupLeader(groupID, leaderID);
        }
        finally {
            this.releaseDSI(dsi);
        }
    }

    public void removeGroup(String groupID) throws StatusException, AccessException {
        Exception ex = null;
        try {
            String groupHome = DSIAdmin.getGroupHomeDir(groupID);
            this.removeGroupResource(groupHome);
        }
        catch (Exception e) {
            ex = e;
        }
        try {
            String groupPublic = DSIAdmin.getGroupPublicDir(groupID);
            this.removeGroupResource(groupPublic);
        }
        catch (Exception e) {
            ex = e;
        }
        if (ex != null) {
            if (ex instanceof StatusException) {
                throw (StatusException)ex;
            }
            if (ex instanceof AccessException) {
                throw (AccessException)ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGroupResource(String url) throws StatusException, AccessException {
        mLogger.fine("Trying to remove directory: " + url);
        DSI dsi = this.getDSI(url);
        DSIAuthService authService = new DSIAuthService(dsi);
        try {
            if (dsi.exists()) {
                if (!authService.isAuthorized(Privilege.WRITE, url, this.mUser)) {
                    mLogger.severe(" (WRITE) access denied for user " + this.mUser);
                    throw new AccessException("You do not have permission to delete the directory: " + url);
                }
                if (!authService.isAuthorized(Privilege.WRITE_ACL, url, this.mUser)) {
                    mLogger.fine("Group leader (WRITE_ACL) access denied for user " + this.mUser);
                    throw new AccessException("Only a group leader can execute this method!");
                }
                dsi.removeResource();
                mLogger.fine("Delete successful.");
            } else {
                mLogger.fine("Directory doesn't exist");
            }
        }
        catch (Exception e) {
            if (e instanceof StatusException) {
                throw (StatusException)e;
            }
            if (e instanceof AccessException) {
                throw (AccessException)e;
            }
            mLogger.severe(LoggerUtils.getStackTrace(e));
        }
        finally {
            authService.close();
            authService = null;
            this.releaseDSI(dsi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupACLs(String groupID, Vector members, Vector admins) throws AccessException {
        String projectsDir = DSIAdmin.getGroupHomeDir(groupID);
        NormalizedAceList projAces = new NormalizedAceList(projectsDir);
        String publicDir = DSIAdmin.getGroupPublicDir(groupID);
        NormalizedAceList pubAces = new NormalizedAceList(publicDir);
        TreeSet combined = new TreeSet();
        combined.addAll(admins);
        combined.addAll(members);
        for (String userID : combined) {
            if (admins.contains(userID)) {
                projAces.addPrivilege(userID, DSIPrivilege.ALL, false);
                pubAces.addPrivilege(userID, DSIPrivilege.WRITE, false);
                pubAces.addPrivilege(userID, DSIPrivilege.WRITE_ACL, false);
                continue;
            }
            projAces.addPrivilege(userID, DSIPrivilege.READ, false);
            projAces.addPrivilege(userID, DSIPrivilege.WRITE, false);
            pubAces.addPrivilege(userID, DSIPrivilege.WRITE, false);
        }
        DSI dsi = this.getDSI(projectsDir);
        DSIAuthService authService = new DSIAuthService(dsi);
        try {
            authService.resetPrivileges(projectsDir, projAces);
            authService.resetPrivileges(publicDir, pubAces);
        }
        finally {
            authService.close();
            authService = null;
            this.releaseDSI(dsi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupMember(String groupID, String userID) throws AccessException {
        String groupHome = DSIAdmin.getGroupHomeDir(groupID);
        Privilege[] privs = new Privilege[]{Privilege.READ, Privilege.WRITE};
        DSI dsi = this.getDSI(groupHome);
        DSIAuthService authService = new DSIAuthService(dsi);
        try {
            authService.addPrivilege(privs, groupHome, userID);
            String groupPublic = DSIAdmin.getGroupPublicDir(groupID);
            authService.addPrivilege(Privilege.WRITE, groupPublic, userID);
        }
        finally {
            authService.close();
            authService = null;
            this.releaseDSI(dsi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupLeader(String groupID, String userID) throws AccessException {
        String groupHome = DSIAdmin.getGroupHomeDir(groupID);
        DSI dsi = this.getDSI(groupHome);
        DSIAuthService authService = new DSIAuthService(dsi);
        try {
            authService.addPrivilege(Privilege.ALL, groupHome, userID);
            Privilege[] privs = new Privilege[]{Privilege.WRITE, Privilege.WRITE_ACL};
            String groupPublic = DSIAdmin.getGroupPublicDir(groupID);
            authService.addPrivilege(privs, groupPublic, userID);
        }
        finally {
            authService.close();
            authService = null;
            this.releaseDSI(dsi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroupMember(String groupID, String userID) throws AccessException {
        mLogger.fine("Trying to remove MEMBER " + userID + " from GROUP" + groupID);
        String groupHome = DSIAdmin.getGroupHomeDir(groupID);
        DSI dsi = this.getDSI(groupHome);
        DSIAuthService authService = new DSIAuthService(dsi);
        try {
            authService.removePrivilege(Privilege.ALL, groupHome, userID);
            String groupPublic = DSIAdmin.getGroupPublicDir(groupID);
            authService.removePrivilege(Privilege.ALL, groupPublic, userID);
        }
        finally {
            authService.close();
            authService = null;
            this.releaseDSI(dsi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGroupLeader(String groupID) {
        boolean ret = false;
        String groupHome = DSIAdmin.getGroupHomeDir(groupID);
        DSI dsi = this.getDSI(groupHome);
        DSIAuthService authService = new DSIAuthService(dsi);
        try {
            ret = authService.isAuthorized(Privilege.WRITE_ACL, groupHome, this.mUser);
        }
        catch (Exception e) {
            mLogger.severe(e.toString());
        }
        finally {
            authService.close();
            authService = null;
            this.releaseDSI(dsi);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserEditor() {
        boolean ret = false;
        String principalsRoot = DSIAdmin.getPrincipalsRootDir();
        DSI dsi = this.getDSI(principalsRoot);
        DSIAuthService authService = new DSIAuthService(dsi);
        try {
            ret = authService.isAuthorized(Privilege.WRITE, principalsRoot, this.mUser);
        }
        catch (Exception e) {
            mLogger.severe(e.toString());
        }
        finally {
            authService.close();
            authService = null;
            this.releaseDSI(dsi);
        }
        return ret;
    }

    public static String getPrincipalDir(String principalID) {
        return SERVER_URL + "/users/" + principalID;
    }

    public static String getPrincipalsRootDir() {
        return SERVER_URL + "/users";
    }

    public static String getTemplateUserDir() {
        return SERVER_URL + "/users/template";
    }

    public static String getUserHomeDir(String userID) {
        return SERVER_URL + "/files/users/" + userID;
    }

    public static String getGroupHomeDir(String groupID) {
        return SERVER_URL + "/files/projects/" + groupID + "/";
    }

    public static String getGroupPublicDir(String groupID) {
        return SERVER_URL + "/files/public/" + groupID + "/";
    }

    public static String getUsersRootDir() {
        return SERVER_URL + "/files/users";
    }

    public static String getProjectsRootDir() {
        return SERVER_URL + "/files/projects";
    }

    public static String getPublicRootDir() {
        return SERVER_URL + "/files/public";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveResource(String resourceUrl, String archDir) throws StatusException, AccessException {
        DSI dsi = this.getDSI("/archive");
        DSIAuthService authService = new DSIAuthService(dsi);
        try {
            if (!dsi.exists()) {
                dsi.setURL("/");
                dsi.makeCollection("archive");
            }
            dsi.setURL("/archive/" + archDir);
            if (!dsi.exists()) {
                dsi.setURL("/archive");
                dsi.makeCollection(archDir);
            }
            dsi.setURL(resourceUrl);
            if (dsi.exists()) {
                String[] split = DSI.splitUrl(resourceUrl);
                String fileName = split[1];
                String moveTo = "/archive/" + archDir + "/" + fileName;
                int count = 1;
                String tmp = moveTo;
                dsi.setURL(tmp);
                while (dsi.exists()) {
                    tmp = moveTo + "_" + Integer.toString(count++);
                    dsi.setURL(tmp);
                }
                moveTo = tmp;
                mLogger.fine("Archiving directory: " + resourceUrl + " to " + moveTo);
                dsi.setURL(resourceUrl);
                dsi.move(moveTo);
                authService.removePrivilege(Privilege.ALL, moveTo, "all");
            }
        }
        finally {
            authService.close();
            authService = null;
            this.releaseDSI(dsi);
        }
    }

    static {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        SERVER_URL = (String)props.get("samserver");
    }
}

