// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BOPDS_CommonBlock_HeaderFile
#define _BOPDS_CommonBlock_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_BOPDS_CommonBlock_HeaderFile
#include <Handle_BOPDS_CommonBlock.hxx>
#endif

#ifndef _BOPDS_ListOfPaveBlock_HeaderFile
#include <BOPDS_ListOfPaveBlock.hxx>
#endif
#ifndef _BOPCol_ListOfInteger_HeaderFile
#include <BOPCol_ListOfInteger.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _BOPCol_BaseAllocator_HeaderFile
#include <BOPCol_BaseAllocator.hxx>
#endif
#ifndef _Handle_BOPDS_PaveBlock_HeaderFile
#include <Handle_BOPDS_PaveBlock.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class BOPDS_PaveBlock;



//! The class BOPDS_CommonBlock is to store <br>
//! the information about pave blocks that have <br>
//!  geometry coincidence (in  terms of a tolerance)  with <br>
//!  a) other pave block(s) <br>
//!  b) face(s) <br>
class BOPDS_CommonBlock : public MMgt_TShared {

public:

  
//! Empty contructor <br>
//! <br>
  Standard_EXPORT   BOPDS_CommonBlock();
  
//!  Contructor <br>
//!  <theAllocator> - the allocator to manage the memory <br>
//! <br>
  Standard_EXPORT   BOPDS_CommonBlock(const BOPCol_BaseAllocator& theAllocator);
  
//! Modifier <br>
//! Adds the pave block <aPB> to the list of pave blocks <br>
//! of the common block <br>
  Standard_EXPORT     void AddPaveBlock(const Handle(BOPDS_PaveBlock)& aPB) ;
  
//! Modifier <br>
//! Adds the list of pave blocks <aLPB> <br>
//! to the list of pave blocks <br>
//! of the common block <br>
  Standard_EXPORT     void AddPaveBlocks(const BOPDS_ListOfPaveBlock& aLPB) ;
  
//! Modifier <br>
//! Adds the index of the face <aF> <br>
//! to the list of indices of faces <br>
//! of the common block <br>
  Standard_EXPORT     void AddFace(const Standard_Integer aF) ;
  
//! Modifier <br>
//! Adds the list of indices of faces <aLF> <br>
//! to the list of indices of faces <br>
//! of the common block <br>
  Standard_EXPORT     void AddFaces(const BOPCol_ListOfInteger& aLF) ;
  
//! Selector <br>
//! Returns the list of pave blocks <br>
//! of the common block <br>
  Standard_EXPORT    const BOPDS_ListOfPaveBlock& PaveBlocks() const;
  
//! Selector <br>
//! Returns the list of indices of faces <br>
//! of the common block <br>
  Standard_EXPORT    const BOPCol_ListOfInteger& Faces() const;
  
//! Selector <br>
//! Returns the first pave block <br>
//! of the common block <br>
  Standard_EXPORT    const Handle_BOPDS_PaveBlock& PaveBlock1() const;
  
//! Selector <br>
//! Returns the pave block that belongs <br>
//! to the edge with index <theIx> <br>
  Standard_EXPORT     Handle_BOPDS_PaveBlock& PaveBlockOnEdge(const Standard_Integer theIndex) ;
  
//! Query <br>
//! Returns true if the common block contains <br>
//!  a pave block that belongs <br>
//! to the face with index <theIx> <br>
  Standard_EXPORT     Standard_Boolean IsPaveBlockOnFace(const Standard_Integer theIndex) const;
  
//! Query <br>
//! Returns true if the common block contains <br>
//!  a pave block that belongs <br>
//! to the edge with index <theIx> <br>
  Standard_EXPORT     Standard_Boolean IsPaveBlockOnEdge(const Standard_Integer theIndex) const;
  
//! Query <br>
//! Returns true if the common block contains <br>
//!  a pave block that is equal  to <thePB> <br>
  Standard_EXPORT     Standard_Boolean Contains(const Handle(BOPDS_PaveBlock)& thePB) const;
  
//! Query <br>
//! Returns true if the common block contains <br>
//!  the face with index equal  to <theF> <br>
  Standard_EXPORT     Standard_Boolean Contains(const Standard_Integer theF) const;
  
//! Modifier <br>
//! Assign the index <theEdge> as the edge index <br>
//! to all pave blocks of the common block <br>
  Standard_EXPORT     void SetEdge(const Standard_Integer theEdge) ;
  
//! Selector <br>
//! Returns the index of the edge <br>
//! of  all pave blocks of the common block <br>
  Standard_EXPORT     Standard_Integer Edge() const;
  
  Standard_EXPORT     void Dump() const;




  DEFINE_STANDARD_RTTI(BOPDS_CommonBlock)

protected:


BOPDS_ListOfPaveBlock myPaveBlocks;
BOPCol_ListOfInteger myFaces;


private: 




};





// other Inline functions and methods (like "C++: function call" methods)


#endif
