// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepAlgo_AsDes_HeaderFile
#define _BRepAlgo_AsDes_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_BRepAlgo_AsDes.hxx>

#include <TopTools_DataMapOfShapeListOfShape.hxx>
#include <MMgt_TShared.hxx>
#include <Standard_Boolean.hxx>
class Standard_ConstructionError;
class TopoDS_Shape;
class TopTools_ListOfShape;


//! SD to store descendants and ascendants of Shapes.
class BRepAlgo_AsDes : public MMgt_TShared
{

public:

  
  //! Creates an empty AsDes.
  Standard_EXPORT BRepAlgo_AsDes();
  
  Standard_EXPORT   void Clear() ;
  
  //! Stores <SS> as a futur subshape of <S>.
  Standard_EXPORT   void Add (const TopoDS_Shape& S, const TopoDS_Shape& SS) ;
  
  //! Stores <SS> as futurs SubShapes of <S>.
  Standard_EXPORT   void Add (const TopoDS_Shape& S, const TopTools_ListOfShape& SS) ;
  
  Standard_EXPORT   Standard_Boolean HasAscendant (const TopoDS_Shape& S)  const;
  
  Standard_EXPORT   Standard_Boolean HasDescendant (const TopoDS_Shape& S)  const;
  
  //! Returns the Shape containing <S>.
  Standard_EXPORT  const  TopTools_ListOfShape& Ascendant (const TopoDS_Shape& S)  const;
  
  //! Returns futur subhapes of <S>.
  Standard_EXPORT  const  TopTools_ListOfShape& Descendant (const TopoDS_Shape& S)  const;
  
  //! Returns futur subhapes of <S>.
  Standard_EXPORT   TopTools_ListOfShape& ChangeDescendant (const TopoDS_Shape& S) ;
  
  //! Replace <OldS> by <NewS>.
  //! <OldS> disapear from <me>.
  Standard_EXPORT   void Replace (const TopoDS_Shape& OldS, const TopoDS_Shape& NewS) ;
  
  //! Remove <S> from me.
  Standard_EXPORT   void Remove (const TopoDS_Shape& S) ;
  
  //! Returns  True if (S1> and <S2>  has  common
  //! Descendants.  Stores in <LC> the Commons Descendants.
  Standard_EXPORT   Standard_Boolean HasCommonDescendant (const TopoDS_Shape& S1, const TopoDS_Shape& S2, TopTools_ListOfShape& LC)  const;




  DEFINE_STANDARD_RTTI(BRepAlgo_AsDes)

protected:




private: 

  
  //! Replace <OldS> by <NewS>.
  //! <OldS> disapear from <me>.
  Standard_EXPORT   void BackReplace (const TopoDS_Shape& OldS, const TopoDS_Shape& NewS, const TopTools_ListOfShape& L, const Standard_Boolean InUp) ;

  TopTools_DataMapOfShapeListOfShape up;
  TopTools_DataMapOfShapeListOfShape down;


};







#endif // _BRepAlgo_AsDes_HeaderFile
