//                                               -*- C++ -*-
/**
 *  @file  OTOptim.hxx
 *  @brief The external header file of Open TURNS for subdir Optim
 *
 *  Copyright (C) 2005-2013 EDF-EADS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author dutka
 *  @date   2009-02-11 16:49:59 +0100 (Wed, 11 Feb 2009)
 */

#ifndef OPENTURNS_OTOPTIM_HXX
#define OPENTURNS_OTOPTIM_HXX

#include "BoundConstrainedAlgorithm.hxx"
#include "BoundConstrainedAlgorithmImplementation.hxx"
#include "BoundConstrainedAlgorithmImplementationResult.hxx"
#include "PenalizedLeastSquaresAlgorithm.hxx"
#include "NearestPointAlgorithm.hxx"
#include "NearestPointAlgorithmImplementation.hxx"
#include "NearestPointAlgorithmImplementationResult.hxx"
#include "NearestPointCheckerResult.hxx"
#include "NearestPointChecker.hxx"
#include "OTAbdoRackwitz.hxx"
#include "OTCobyla.hxx"
#include "OTSQP.hxx"
#include "OTTNC.hxx"

#endif /* OPENTURNS_OTOPTIM_HXX */
