#! /usr/bin/env python

from __future__ import print_function
from openturns import *

TESTPREAMBLE()

# Create an intance
myFunc = DynamicalFunction()

print('myFunc=', myFunc)
# Get the input and output description
print('myFunc input description=', myFunc.getInputDescription())
print('myFunc output description=', myFunc.getOutputDescription())
# Get the input and output dimension, based on description
print('myFunc input dimension=', myFunc.getInputDimension())
print('myFunc output dimension=', myFunc.getOutputDimension())
print('myFunc spatial dimension=', myFunc.getSpatialDimension())
# Get the number of calls
print('called ', myFunc.getCallsNumber(), ' times')


def myPyFunc(X):
    mesh = X.getMesh()
    Y = Field(mesh, Normal().getSample(mesh.getVerticesNumber()))
    return Y

in_dim = 3
out_dim = 1
spatial_dim = 3

myFunc = PythonDynamicalFunction(in_dim, out_dim, spatial_dim, myPyFunc)
print('myFunc=', myFunc)

vertices = NumericalSample(0, in_dim)
vertices.add([0.0, 0.0, 0.0])
vertices.add([0.0, 0.0, 1.0])
vertices.add([0.0, 1.0, 0.0])
vertices.add([0.0, 1.0, 1.0])
vertices.add([1.0, 0.0, 0.0])
vertices.add([1.0, 0.0, 1.0])
vertices.add([1.0, 1.0, 0.0])
vertices.add([1.0, 1.0, 1.0])
simplicies = IndicesCollection(6, [0] * 4)
simplicies[0] = [0, 1, 2, 4]
simplicies[1] = [3, 5, 6, 7]
simplicies[2] = [1, 2, 3, 6]
simplicies[3] = [1, 2, 4, 6]
simplicies[4] = [1, 3, 5, 6]
simplicies[5] = [1, 4, 5, 6]
mesh3D = Mesh(vertices, simplicies)
values = Normal(spatial_dim).getSample(mesh3D.getVerticesNumber())
X = Field(mesh3D, values)
print('X=', X)
Y = myFunc(X)
print('Y=', Y)
print('myFunc input dimension=', myFunc.getInputDimension())
print('myFunc output dimension=', myFunc.getOutputDimension())
print('myFunc spatial dimension=', myFunc.getSpatialDimension())
print('called ', myFunc.getCallsNumber(), ' times')
