///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/rendering/PluginRenderer.h>
#include <core/data/ObjectLoadStream.h>
#include <core/data/ObjectSaveStream.h>
#include <core/plugins/PluginManager.h>

namespace Core {

IMPLEMENT_ABSTRACT_PLUGIN_CLASS(PluginRenderer, RefTarget)

/******************************************************************************
* Constructor.
******************************************************************************/
PluginRenderer::PluginRenderer(bool isLoading) : RefTarget(isLoading), _renderSettings(NULL)
{
}

/******************************************************************************
* Saves the class' contents to the given stream. 
******************************************************************************/
void PluginRenderer::saveToStream(ObjectSaveStream& stream)
{
	RefTarget::saveToStream(stream);

	stream.beginChunk(0x14A2334);
	stream.endChunk();
}

/******************************************************************************
* Loads the class' contents from the given stream. 
******************************************************************************/
void PluginRenderer::loadFromStream(ObjectLoadStream& stream)
{
	RefTarget::loadFromStream(stream);

	stream.expectChunk(0x14A2334);
	stream.closeChunk();
}

/******************************************************************************
* Returns the list of installed plugin renderer classes. 
******************************************************************************/
QList<PluginClassDescriptor*> PluginRenderer::availableRendererClasses()
{
	QList<PluginClassDescriptor*> list;
	
	Q_FOREACH(PluginClassDescriptor* clazz, PLUGIN_MANAGER.listClasses(PLUGINCLASSINFO(PluginRenderer)))
		list.push_back(clazz);
		
	return list;
}

};
