///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/gui/properties/BooleanPropertyUI.h>
#include <core/gui/properties/BooleanGroupBoxPropertyUI.h>
#include <core/gui/properties/IntegerRadioButtonPropertyUI.h>
#include <core/gui/properties/IntegerPropertyUI.h>
#include "TachyonRenderer.h"
#include "TachyonRendererEditor.h"

namespace TachyonPlugin {

IMPLEMENT_PLUGIN_CLASS(TachyonRendererEditor, PropertiesEditor)

/******************************************************************************
* Creates the UI controls for the editor.
******************************************************************************/
void TachyonRendererEditor::createUI(const RolloutInsertionParameters& rolloutParams)
{
	// Create the rollout.
	QWidget* rollout = createRollout(tr("Tachyon settings"), rolloutParams);

	QVBoxLayout* mainLayout = new QVBoxLayout(rollout);
	mainLayout->setContentsMargins(4,4,4,4);

	// Antialiasing
	BooleanGroupBoxPropertyUI* enableAntialiasingUI = new BooleanGroupBoxPropertyUI(this, PROPERTY_FIELD_DESCRIPTOR(TachyonRenderer, _enableAntialiasing));
	QGroupBox* aaGroupBox = enableAntialiasingUI->groupBox();
	mainLayout->addWidget(aaGroupBox);

	QGridLayout* layout = new QGridLayout(aaGroupBox);
	layout->setContentsMargins(4,4,4,4);
	layout->setSpacing(2);
	layout->setColumnStretch(1, 1);

	IntegerPropertyUI* aaSamplesUI = new IntegerPropertyUI(this, PROPERTY_FIELD_DESCRIPTOR(TachyonRenderer, _antialiasingSamples));
	layout->addWidget(aaSamplesUI->label(), 0, 0);
	layout->addLayout(aaSamplesUI->createFieldLayout(), 0, 1);
	aaSamplesUI->setMinValue(1);
	aaSamplesUI->setMaxValue(100);

	QGroupBox* renderingModeGroupBox = new QGroupBox(tr("Rendering mode"));
	mainLayout->addWidget(renderingModeGroupBox);

	layout = new QGridLayout(renderingModeGroupBox);
	layout->setContentsMargins(4,4,4,4);
	layout->setSpacing(2);
	layout->setColumnStretch(1, 1);

	// Rendering mode.
	IntegerRadioButtonPropertyUI* renderingModeUI = new IntegerRadioButtonPropertyUI(this, PROPERTY_FIELD_DESCRIPTOR(TachyonRenderer, _renderingMode));
	layout->addWidget(renderingModeUI->addRadioButton(0, tr("No shadows")), 0, 0, 1, 2);
	layout->addWidget(renderingModeUI->addRadioButton(1, tr("Shadows")), 1, 0, 1, 2);
	layout->addWidget(renderingModeUI->addRadioButton(2, tr("Shadows + ambient occlusion")), 2, 0, 1, 2);

	// Ambient occlusion samples.
	IntegerPropertyUI* aoSamplesUI = new IntegerPropertyUI(this, PROPERTY_FIELD_DESCRIPTOR(TachyonRenderer, _ambientOcclusionSamples));
	layout->addWidget(aoSamplesUI->label(), 3, 0);
	layout->addLayout(aoSamplesUI->createFieldLayout(), 3, 1);
	aoSamplesUI->setMinValue(1);
	aoSamplesUI->setMaxValue(100);

	// Copyright notice
	QWidget* copyrightRollout = createRollout(tr("About"), rolloutParams.collapse().after(rollout));
	mainLayout = new QVBoxLayout(copyrightRollout);
	mainLayout->setContentsMargins(4,4,4,4);
	QLabel* label = new QLabel(tr("Tachyon Parallel / Multiprocessor Ray Tracing System<br>Copyright (c) 1994-2011 John E. Stone<br><a href=\"http://jedi.ks.uiuc.edu/~johns/raytracer\">Go to Tachyon website</a>"));
	label->setWordWrap(true);
	label->setOpenExternalLinks(true);
	mainLayout->addWidget(label);
}

};
