/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.eventutils;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseIntegerTrigger
extends AbstractNode
implements VRMLChildNodeType {
    protected static final int FIELD_SET_BOOLEAN = 1;
    protected static final int FIELD_INTEGER_KEY = 2;
    protected static final int FIELD_TRIGGER_VALUE = 3;
    protected static final int LAST_INTEGER_TRIGGER_INDEX = 3;
    protected static final int NUM_FIELDS = 4;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private int vfIntegerKey;

    public BaseIntegerTrigger() {
        super("IntegerTrigger");
        this.hasChanged = new boolean[4];
        this.vfIntegerKey = -1;
    }

    public BaseIntegerTrigger(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("integerKey");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfIntegerKey = vRMLFieldData.intValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 7;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.intValue = this.vfIntegerKey;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.intValue = this.vfIntegerKey;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfIntegerKey);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfIntegerKey);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseIntegerTrigger.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseIntegerTrigger.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                throw new InvalidFieldValueException("Cannot set eventout");
            }
            case 2: {
                this.setIntegerKey(n2);
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setBoolean(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    private void setBoolean(boolean bl) {
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    private void setIntegerKey(int n) {
        this.vfIntegerKey = n;
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(12);
        BaseIntegerTrigger.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseIntegerTrigger.fieldDecl[1] = new VRMLFieldDeclaration(1, "SFBool", "set_boolean");
        BaseIntegerTrigger.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFInt32", "integerKey");
        BaseIntegerTrigger.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFInt32", "triggerValue");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("set_boolean", n);
        n = new Integer(2);
        fieldMap.put("integerKey", n);
        fieldMap.put("set_integerKey", n);
        fieldMap.put("integerKey_changed", n);
        n = new Integer(3);
        fieldMap.put("triggerValue", n);
    }
}

